/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.impl.servlets;

import com.day.cq.analytics.sitecatalyst.EvarFilter;
import com.day.cq.analytics.sitecatalyst.EventFilter;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.analytics.sitecatalyst.TrafficVarFilter;
import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.paths", value={"/libs/cq/analytics/sitecatalyst/variables"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class VariablesServlet
extends SlingSafeMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Integer HOURS_CACHEEXPIRATION = -1;
    private static final String PN_TRAFFIC = "traffic";
    private static final String PN_CONVERSION = "conversion";
    private static final String PN_EVENT = "event";
    private static final String PN_CACHEDATE = "cacheDate";
    private static final String TIDY_PARAM = "tidy";
    private static final String FORCE_PARAM = "force";
    private static final String PATH_PARAM = "path";
    private static final String[] hardcodedEvents = new String[]{"", "purchase", "purchase", "purchase", "scOpen", "scView", "", "scCheckout", "scAdd", "scRemove"};
    private static final String[][] standardConversionVariables = new String[][]{{"campaign", "Campaign"}, {"transactionID", "Transaction ID"}, {"visitorID", "Visitor ID"}, {"purchaseID", "Purchase ID"}, {"products", "Products"}, {"product.category", "Product Category"}, {"product.sku", "Product SKU"}, {"product.quantity", "Product Quantity"}, {"product.price", "Product Price"}, {"state", "State"}, {"zip", "ZIP"}, {"list1", "Variable List 1"}, {"list2", "Variable List 2"}, {"list3", "Variable List 3"}};
    private static final String[][] standardTrafficVariables = new String[][]{{"channel", "Channel"}, {"pageName", "Page Name"}, {"pageType", "Page Type"}, {"pageURL", "Page URL"}, {"server", "Server"}, {"hier1", "Hierarchy 1"}, {"hier2", "Hierarchy 2"}, {"hier3", "Hierarchy 3"}, {"hier4", "Hierarchy 4"}, {"hier5", "Hierarchy 5"}};
    private static final String[][] standardEventsVariables = new String[][]{{"prodView", "Product View"}};
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private SitecatalystWebservice sitecatalyst;

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String tidy = request.getParameter(TIDY_PARAM);
            String path = request.getParameter(PATH_PARAM);
            Boolean force = Boolean.parseBoolean(request.getParameter(FORCE_PARAM));
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            TidyJSONWriter json = new TidyJSONWriter((Writer)response.getWriter());
            json.setTidy("true".equals(tidy));
            json.object();
            json.key("variables").array();
            Configuration config = this.configManager.getConfiguration(this.cleanPath(path));
            if (config != null) {
                String trafficJson = this.getTrafficVariables(config, force);
                String conversionJson = this.getConversionVariables(config, force);
                String eventJson = this.getEventVariables(config, force);
                this.writeTrafficVariables(request, (JSONWriter)json, trafficJson);
                this.writeEvars(request, (JSONWriter)json, conversionJson);
                this.writeEvents(request, (JSONWriter)json, eventJson);
            }
            json.endArray();
            json.endObject();
        }
        catch (Exception e) {
            this.log.error("Exception occured while calling Sitecatalyst service", (Throwable)e);
            throw new ServletException("Exception occured while calling Sitecatalyst service", (Throwable)e);
        }
    }

    private String getTrafficVariables(Configuration config, Boolean force) {
        String response = "";
        Boolean isCached = this.hasCache(config, PN_TRAFFIC);
        if (!force.booleanValue() && isCached.booleanValue()) {
            response = (String)config.getInherited(PN_TRAFFIC, null);
        } else {
            try {
                String reportSuite = (String)config.getInherited("reportsuite", null);
                if (reportSuite != null) {
                    response = this.sitecatalyst.getTrafficVars(config, reportSuite);
                    this.setProperty(config, PN_TRAFFIC, response);
                }
            }
            catch (SitecatalystException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    private void writeStandardVariables(SlingHttpServletRequest request, JSONWriter json, String[][] variables, String variableType) throws JSONException {
        for (int i = 0; i < variables.length; ++i) {
            json.object();
            json.key(PATH_PARAM).value((Object)request.getRequestURI());
            json.key("no").value((Object)variables[i][0]);
            json.key("name").value((Object)variables[i][0]);
            json.key("uid").value((Object)variables[i][0]);
            json.key("title").value((Object)("[{'name': '" + variables[i][1] + "', 'rsid': ' '}]"));
            json.key("type").value((Object)variableType);
            json.endObject();
        }
    }

    private void writeTrafficVariables(SlingHttpServletRequest request, JSONWriter json, String variablesJson) throws JSONException {
        TrafficVarFilter filter = new TrafficVarFilter();
        JSONArray props = this.getJsonArray(variablesJson, "traffic_vars");
        this.writeStandardVariables(request, json, standardTrafficVariables, PN_TRAFFIC);
        for (int i = 0; i < props.length(); ++i) {
            JSONObject obj = props.getJSONObject(i);
            if (!filter.filter(obj).booleanValue()) continue;
            json.object();
            json.key(PATH_PARAM).value((Object)request.getRequestURI());
            json.key("no").value(obj.get("property_number"));
            json.key("name").value((Object)("prop" + obj.get("property_number")));
            json.key("uid").value((Object)("prop" + obj.get("property_number")));
            json.key("title").value(obj.get("name"));
            json.key("type").value((Object)PN_TRAFFIC);
            json.endObject();
        }
    }

    private String getConversionVariables(Configuration config, Boolean force) {
        String response = "";
        Boolean isCached = this.hasCache(config, PN_CONVERSION);
        if (!force.booleanValue() && isCached.booleanValue()) {
            response = (String)config.getInherited(PN_CONVERSION, null);
        } else {
            try {
                String reportSuite = (String)config.getInherited("reportsuite", null);
                if (reportSuite != null) {
                    response = this.sitecatalyst.getEvars(config, reportSuite);
                    this.setProperty(config, PN_CONVERSION, response);
                }
            }
            catch (SitecatalystException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    private void writeEvars(SlingHttpServletRequest request, JSONWriter json, String variablesJson) throws JSONException {
        EvarFilter filter = new EvarFilter();
        JSONArray evars = this.getJsonArray(variablesJson, "evars");
        this.writeStandardVariables(request, json, standardConversionVariables, PN_CONVERSION);
        for (int i = 0; i < evars.length(); ++i) {
            JSONObject obj = evars.getJSONObject(i);
            if (!filter.filter(obj).booleanValue()) continue;
            json.object();
            json.key(PATH_PARAM).value((Object)request.getRequestURI());
            json.key("no").value(obj.get("evar_num"));
            json.key("name").value((Object)("eVar" + obj.get("evar_num")));
            json.key("uid").value((Object)("eVar" + obj.get("evar_num")));
            json.key("title").value(obj.get("name"));
            json.key("type").value((Object)PN_CONVERSION);
            json.endObject();
        }
    }

    private String getEventVariables(Configuration config, Boolean force) {
        String response = "";
        Boolean isCached = this.hasCache(config, PN_EVENT);
        if (!force.booleanValue() && isCached.booleanValue()) {
            response = (String)config.getInherited(PN_EVENT, null);
        } else {
            try {
                String reportSuite = (String)config.getInherited("reportsuite", null);
                if (reportSuite != null) {
                    response = this.sitecatalyst.getSuccessEvents(config, reportSuite);
                    this.setProperty(config, PN_EVENT, response);
                }
            }
            catch (SitecatalystException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    private void writeEvents(SlingHttpServletRequest request, JSONWriter json, String variablesJson) throws SitecatalystException, JSONException {
        EventFilter filter = new EventFilter();
        JSONArray events = this.getJsonArray(variablesJson, "events");
        this.writeStandardVariables(request, json, standardEventsVariables, PN_EVENT);
        for (int i = 0; i < events.length(); ++i) {
            String eventName;
            JSONObject obj = events.getJSONObject(i);
            if (!filter.filter(obj).booleanValue()) continue;
            json.object();
            json.key(PATH_PARAM).value((Object)request.getRequestURI());
            Integer eventNumber = (Integer)obj.opt("event_number");
            if (eventNumber != null) {
                eventName = PN_EVENT + eventNumber;
            } else {
                int relId = obj.getInt("rel_id");
                eventNumber = -relId;
                try {
                    eventName = hardcodedEvents[relId];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.log.warn("writeEvents: Unknown rel_id {}", (Object)obj);
                    eventName = hardcodedEvents[0];
                }
            }
            json.key("no").value((Object)eventNumber);
            json.key("name").value((Object)eventName);
            json.key("uid").value((Object)(PN_EVENT + eventNumber));
            json.key("title").value(obj.get("event_name"));
            json.key("type").value((Object)PN_EVENT);
            json.endObject();
        }
    }

    private String cleanPath(String path) {
        int idx;
        if (path != null && (idx = path.indexOf(".html")) > -1) {
            return path.substring(0, idx);
        }
        return path != null ? path : "";
    }

    private JSONArray getJsonArray(String responseString, String key) {
        try {
            JSONObject json = new JSONObject(responseString);
            return json.getJSONArray(key);
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    private Boolean hasCache(Configuration config, String cacheProperty) {
        String cache = (String)config.getInherited(cacheProperty, null);
        Calendar cacheDate = (Calendar)config.getInherited(PN_CACHEDATE, null);
        if (cache == null || cacheDate == null) {
            return Boolean.FALSE;
        }
        Calendar cacheTreshold = Calendar.getInstance();
        cacheTreshold.add(10, HOURS_CACHEEXPIRATION);
        if (cache != null && cacheDate.before(cacheTreshold)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setProperty(Configuration config, String property, String value) {
        Node node = (Node)config.getContentResource().adaptTo(Node.class);
        try {
            node.setProperty(property, value);
            node.setProperty(PN_CACHEDATE, Calendar.getInstance());
            node.getSession().save();
        }
        catch (RepositoryException e) {
            try {
                node.getSession().refresh(false);
            }
            catch (RepositoryException ignore) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindSitecatalyst(SitecatalystWebservice sitecatalystWebservice) {
        this.sitecatalyst = sitecatalystWebservice;
    }

    protected void unbindSitecatalyst(SitecatalystWebservice sitecatalystWebservice) {
        if (this.sitecatalyst == sitecatalystWebservice) {
            this.sitecatalyst = null;
        }
    }
}

