/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.util.MboxHelper;
import com.day.cq.wcm.api.Page;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%cq.analytics.testandtarget.mboxparagraphpostprocessor.name", description="%cq.analytics.testandtarget.mboxparagraphpostprocessor.description")
@Service(value={SlingPostProcessor.class})
public class MboxParagraphPostProcessor
implements SlingPostProcessor {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Property(boolValue={true})
    public static final String ENABLED = "cq.analytics.testandtarget.mboxparagraphpostprocessor.enabled";
    private final String PAGE_MARKER = "/jcr:content/";
    private boolean enabled;

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if (this.enabled) {
            HashSet<String> fixPaths = new HashSet<String>();
            for (Modification mod : changes) {
                switch (mod.getType()) {
                    case ORDER: 
                    case MOVE: 
                    case COPY: {
                        break;
                    }
                    case MODIFY: 
                    case CREATE: 
                    case DELETE: {
                        int pageEndPos = mod.getSource().indexOf("/jcr:content/");
                        if (pageEndPos == -1) break;
                        String pagePath = mod.getSource().substring(0, pageEndPos);
                        fixPaths.add(pagePath);
                    }
                }
            }
            ResourceResolver resolver = request.getResourceResolver();
            for (String pagePath : fixPaths) {
                this.logger.debug("Checking if resource '{}' is a page", (Object)pagePath);
                if (resolver.getResource(pagePath).adaptTo(Page.class) == null) {
                    this.logger.debug("resource is not adaptable to Page, skipping");
                    continue;
                }
                String contentPath = pagePath + '/' + "jcr:content";
                this.logger.debug("Checking page for mbox paragraphs {}", (Object)pagePath);
                Resource contentResource = resolver.getResource(contentPath);
                if (contentResource == null) continue;
                this.fixStructure(contentResource);
            }
        }
    }

    private String getStartResourceType() {
        return "cq/personalization/components/mbox/start";
    }

    private String getEndResourceType() {
        return "cq/personalization/components/mbox/end";
    }

    private String getNodeNamePrefix() {
        return "mbox";
    }

    private void fixStructure(Resource contentResource) throws RepositoryException {
        Iterator rI = ResourceUtil.listChildren((Resource)contentResource);
        while (rI.hasNext()) {
            Resource res = (Resource)rI.next();
            if (ResourceUtil.isA((Resource)res, (String)this.getStartResourceType())) {
                this.checkStructure(res);
                continue;
            }
            if (ResourceUtil.isA((Resource)res, (String)this.getEndResourceType())) {
                this.checkStructure(res);
                continue;
            }
            this.fixStructure(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource checkStructure(Resource rsrc) {
        Resource elementStart;
        if (ResourceUtil.isA((Resource)rsrc, (String)this.getStartResourceType())) {
            Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
            while (!((Resource)iter.next()).getPath().equals(rsrc.getPath())) {
            }
            Resource elementEnd = null;
            Resource nextPar = null;
            boolean stop = false;
            while (iter.hasNext() && elementEnd == null && !stop) {
                Resource current = (Resource)iter.next();
                if (nextPar == null) {
                    nextPar = current;
                }
                if (ResourceUtil.isA((Resource)current, (String)this.getEndResourceType())) {
                    elementEnd = current;
                    continue;
                }
                if (!ResourceUtil.isA((Resource)current, (String)this.getStartResourceType())) continue;
                stop = true;
            }
            if (elementEnd == null) {
                Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
                if (parent != null) {
                    try {
                        String nodeName = this.getNodeNamePrefix() + "_end_" + System.currentTimeMillis();
                        Node node = parent.addNode(nodeName);
                        String resourceType = this.getEndResourceType();
                        node.setProperty("sling:resourceType", resourceType);
                        if (!resourceType.equals(this.getEndResourceType())) {
                            node.setProperty("sling:resourceSuperType", this.getEndResourceType());
                        }
                        if (nextPar != null) {
                            parent.orderBefore(node.getName(), ResourceUtil.getName((Resource)nextPar));
                        }
                        parent.getSession().save();
                        Iterator i = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
                        while (true) {
                            if (!i.hasNext()) break;
                            Resource r = (Resource)i.next();
                            if (!nodeName.equals(ResourceUtil.getName((Resource)r))) continue;
                            Resource resource = r;
                            return resource;
                        }
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Unable to create missing " + this.getNodeNamePrefix() + " end element for " + this.getNodeNamePrefix() + " start " + rsrc, (Throwable)re);
                    }
                    finally {
                        try {
                            if (parent.getSession().hasPendingChanges()) {
                                parent.getSession().refresh(false);
                            }
                        }
                        catch (RepositoryException re) {}
                    }
                } else {
                    this.logger.error("Resource is not adaptable to node - unable to add missing " + this.getNodeNamePrefix() + " end element for " + rsrc);
                }
            }
        } else if (ResourceUtil.isA((Resource)rsrc, (String)this.getEndResourceType()) && (elementStart = MboxHelper.searchStartElement(rsrc)) == null) {
            Node node = (Node)rsrc.adaptTo(Node.class);
            Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
            if (node != null && parent != null) {
                try {
                    node.remove();
                    parent.getSession().save();
                    Resource stop = rsrc;
                    return stop;
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to create missing " + this.getNodeNamePrefix() + " end element for " + this.getNodeNamePrefix() + " start " + rsrc, (Throwable)re);
                }
                finally {
                    try {
                        if (node.getSession().hasPendingChanges()) {
                            node.getSession().refresh(false);
                        }
                    }
                    catch (RepositoryException re) {}
                }
            }
            this.logger.error("Resource is not adaptable to node - unable to remove " + this.getNodeNamePrefix() + " element " + rsrc);
        }
        return null;
    }

    @Activate
    protected void activate(ComponentContext context) {
        Dictionary configuration = context.getProperties();
        this.enabled = (Boolean)configuration.get(ENABLED);
        this.logger.debug("Activated, enabled={}", (Object)this.enabled);
    }
}

