/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.TestandtargetCampaignMediator;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.wcm.api.PageEvent;
import com.day.cq.wcm.api.PageModification;
import java.util.EnumSet;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobProcessor;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={EventHandler.class})
@Component(immediate=true, metatype=true, label="%cq.analytics.testandtarget.pushauthorcampaignpagelistener.name", description="%cq.analytics.testandtarget.pushauthorcampaignpagelistener.description")
@Property(name="event.topics", value={"com/day/cq/wcm/core/page"}, propertyPrivate=true)
public class PushAuthorCampaignPageListener
implements JobProcessor,
EventHandler {
    private static final Logger log = LoggerFactory.getLogger(PushAuthorCampaignPageListener.class);
    private static final EnumSet<PageModification.ModificationType> handledModificationTypes = EnumSet.of(PageModification.ModificationType.CREATED, PageModification.ModificationType.MODIFIED, PageModification.ModificationType.DELETED);
    private static final boolean DEFAULT_ENABLED = true;
    @Property(boolValue={true})
    private static final String PROPERTY_ENABLED = "cq.analytics.testandtarget.pushauthorcampaignpagelistener.enabled";
    @Reference
    private TestandtargetCampaignMediator campaignMediator;
    private boolean enabled;

    protected void activate(ComponentContext ctx) {
        this.enabled = OsgiUtil.toBoolean(ctx.getProperties().get(PROPERTY_ENABLED), (boolean)true);
    }

    public void handleEvent(Event event) {
        if (EventUtil.isLocal((Event)event)) {
            EventUtil.processJob((Event)event, (JobProcessor)this);
        }
    }

    public boolean process(Event job) {
        if (!this.enabled) {
            return true;
        }
        try {
            this.processInternal(job);
        }
        catch (RepositoryException e) {
            log.warn("Failed processing " + job, (Throwable)e);
        }
        catch (TestandtargetException e) {
            log.warn("Failed processing " + job, (Throwable)e);
        }
        catch (LoginException e) {
            log.warn("Failed processing " + job, (Throwable)e);
        }
        return true;
    }

    private void processInternal(Event job) throws RepositoryException, TestandtargetException, LoginException {
        PageEvent pageEvent = PageEvent.fromEvent((Event)job);
        Iterator it = pageEvent.getModifications();
        while (it.hasNext()) {
            PageModification modification = (PageModification)it.next();
            if (!handledModificationTypes.contains(modification.getType())) continue;
            String pagePath = modification.getPath();
            if (modification.getType() == PageModification.ModificationType.DELETED) {
                pagePath = ResourceUtil.getParent((String)pagePath);
            }
            this.campaignMediator.syncAuthorCampaign(pagePath);
        }
    }

    protected void bindCampaignMediator(TestandtargetCampaignMediator testandtargetCampaignMediator) {
        this.campaignMediator = testandtargetCampaignMediator;
    }

    protected void unbindCampaignMediator(TestandtargetCampaignMediator testandtargetCampaignMediator) {
        if (this.campaignMediator == testandtargetCampaignMediator) {
            this.campaignMediator = null;
        }
    }
}

