/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.TestandtargetCampaignMediator;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationResult;
import com.day.cq.replication.ReplicationTransaction;
import com.day.cq.replication.TransportContext;
import com.day.cq.replication.TransportHandler;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={TransportHandler.class})
public class PushPublishCampaignTransportHandler
implements TransportHandler {
    @Reference
    private TestandtargetCampaignMediator campaignMediator;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver adminResolver;

    protected void activate(ComponentContext ctx) throws ComponentException {
        try {
            this.adminResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            throw new ComponentException((Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (this.adminResolver != null) {
            this.adminResolver.close();
        }
    }

    public boolean canHandle(AgentConfig config) {
        return config.getTransportURI().startsWith("tnt://");
    }

    public ReplicationResult deliver(TransportContext ctx, ReplicationTransaction tx) throws ReplicationException {
        try {
            return this.process(tx);
        }
        catch (RepositoryException e) {
            return this.logAndReturn(tx, e);
        }
        catch (LoginException e) {
            return this.logAndReturn(tx, e);
        }
        catch (TestandtargetException e) {
            return this.logAndReturn(tx, e);
        }
    }

    private ReplicationResult logAndReturn(ReplicationTransaction tx, Throwable t) {
        tx.getLog().error("Error replicating " + tx.getAction().getPath() + " - " + t.getClass().getName() + " : " + t.getMessage());
        return new ReplicationResult(false, 0, t.getMessage());
    }

    private ReplicationResult process(ReplicationTransaction tx) throws RepositoryException, LoginException, TestandtargetException, ReplicationException {
        String path = tx.getAction().getPath();
        switch (tx.getAction().getType()) {
            case ACTIVATE: {
                this.campaignMediator.syncPublishCampaign(path);
                return new ReplicationResult(true, 0, null);
            }
            case DEACTIVATE: {
                this.campaignMediator.deactivatePublishCampaign(path);
                return new ReplicationResult(true, 0, null);
            }
            case DELETE: {
                this.campaignMediator.deactivatePublishCampaign(ResourceUtil.getParent((String)path));
                return new ReplicationResult(true, 0, null);
            }
        }
        throw new ReplicationException("Not supported");
    }

    public ReplicationResult poll(TransportContext ctx, ReplicationTransaction tx, List<ReplicationContent> result, ReplicationContentFactory factory) throws ReplicationException {
        throw new ReplicationException("Not supported");
    }

    protected void bindCampaignMediator(TestandtargetCampaignMediator testandtargetCampaignMediator) {
        this.campaignMediator = testandtargetCampaignMediator;
    }

    protected void unbindCampaignMediator(TestandtargetCampaignMediator testandtargetCampaignMediator) {
        if (this.campaignMediator == testandtargetCampaignMediator) {
            this.campaignMediator = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

