/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TestandTargetOperator {
    CONTAINS_IGNORE_CASE,
    DOES_NOT_CONTAIN_IGNORE_CASE,
    EQUALS,
    DOES_NOT_EQUAL_IGNORE_CASE,
    EQUALS_IGNORE_CASE,
    PARAM_PRESENT,
    PARAM_NOT_PRESENT,
    PARAM_NOT_PRESENT_OR_VALUE_NOT_PRESENT,
    PARAM_VALUE_PRESENT,
    GREATER,
    GREATER_EQUALS,
    LESSER,
    LESSER_EQUALS;

    private final String apiValue;

    private TestandTargetOperator() {
        StringBuilder out = new StringBuilder();
        boolean previousWasUnderscore = false;
        String name = this.name();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_') {
                previousWasUnderscore = true;
                continue;
            }
            if (previousWasUnderscore) {
                out.append(name.charAt(i));
            } else {
                out.append(Character.toLowerCase(name.charAt(i)));
            }
            previousWasUnderscore = false;
        }
        this.apiValue = out.toString();
    }

    String getApiValue() {
        return this.apiValue;
    }

    public static String getTestandTargetOperator(String cqOperator) {
        if ("younger".equals(cqOperator) || "less".equals(cqOperator)) {
            return TestandTargetOperator.LESSER.apiValue;
        }
        if ("olderorequal".equals(cqOperator) || "greaterorequal".equals(cqOperator)) {
            return TestandTargetOperator.GREATER_EQUALS.apiValue;
        }
        if ("lessorequal".equals(cqOperator) || "youngerorequal".equals(cqOperator)) {
            return TestandTargetOperator.LESSER_EQUALS.apiValue;
        }
        if ("contains".equals(cqOperator)) {
            return TestandTargetOperator.CONTAINS_IGNORE_CASE.apiValue;
        }
        if ("older".equals(cqOperator)) {
            return TestandTargetOperator.GREATER.apiValue;
        }
        return cqOperator;
    }
}

