/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.impl.TestandTargetCampaignType;
import com.day.cq.analytics.testandtarget.impl.TestandtargetExperience;
import com.day.cq.analytics.testandtarget.impl.TestandtargetOffer;
import com.day.cq.analytics.testandtarget.impl.TestandtargetSegment;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestandtargetCampaign {
    private static final int BRANCH_NAME_MAX_SIZE = 20;
    private static final String HTML_CAMPAIGN_FORMAT = "<script type=\"text/javascript\">CQ_Analytics.TestTarget.pull('%s');</script>";
    private static final String XML_TAG_CAMPAIGN = "campaign";
    private static final String XML_TAG_ALGORITHM = "algorithm";
    private static final String XML_TAG_NAME = "name";
    private static final String XML_TAG_START = "start";
    private static final String XML_TAG_END = "end";
    private static final String XML_TAG_BRANCHES = "branches";
    private static final String XML_TAG_BRANCH = "branch";
    private static final String XML_TAG_PERCENT_CONSTRAINT = "percentConstraint";
    private static final String XML_TAG_PERCENT = "percent";
    private static final String XML_TAG_PARAM_CONSTRAINTS = "paramConstraints";
    private static final String XML_TAG_PARAM_CONSTRAINT = "paramConstraint";
    private static final String XML_TAG_PARAMETER_TYPE = "parameterType";
    private static final String XML_TAG_MATCHER_TYPE = "matcherType";
    private static final String XML_TAG_VALUES = "values";
    private static final String XML_TAG_STRING = "string";
    private static final String XML_TAG_OFFER = "offer";
    private static final String XML_TAG_OFFERS = "offers";
    private static final String XML_TAG_DISPLAY = "display";
    private static final String XML_TAG_DISPLAYS = "displays";
    private static final String XML_TAG_MBOX = "mbox";
    private static final String XML_TAG_MBOXES = "mboxes";
    private static final String XML_TAG_LOCATION = "location";
    private static final String XML_TAG_LOCATIONS = "locations";
    private static final String XML_TAG_TYPE = "type";
    private static final String XML_TAG_STEP = "step";
    private static final String XML_TAG_STEPS = "steps";
    private static final String XML_TAG_CONTENT = "content";
    private static final String OFFER_NAME_DEFAULT_CONTENT = "Default Content";
    private final String name;
    private final String start;
    private final String end;
    private final String conversionGoal;
    private final TestandTargetCampaignType campaignType;
    private final List<TestandtargetExperience> experiences = new ArrayList<TestandtargetExperience>();

    public TestandtargetCampaign(String name, Date start, Date end, String conversionGoal, TestandTargetCampaignType campaignType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.name = name;
        this.start = start != null ? dateFormat.format(start) : "When Approved";
        this.end = end != null ? dateFormat.format(end) : "When Deactivated";
        this.conversionGoal = conversionGoal;
        this.campaignType = campaignType;
    }

    public String asXml() {
        try {
            String algorithm;
            SAXTransformerFactory f = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            TransformerHandler handler = f.newTransformerHandler();
            Transformer t = handler.getTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            MultiValueMap mboxNameToExperience = MultiValueMap.decorate(new LinkedHashMap(), LinkedHashSet.class);
            for (TestandtargetExperience experience : this.experiences) {
                for (TestandtargetOffer offer : experience.getOffers()) {
                    mboxNameToExperience.put((Object)offer.getMbox(), (Object)experience);
                }
            }
            ArrayList<String> allExperienceNames = new ArrayList<String>(this.experiences.size());
            for (TestandtargetExperience experience : this.experiences) {
                allExperienceNames.add(experience.getName());
            }
            handler.setResult(sr);
            handler.startDocument();
            this.startElement(handler, XML_TAG_CAMPAIGN);
            String string = algorithm = this.campaignType != null ? this.campaignType.getTestAndTargetAlgorithm() : null;
            if (algorithm != null) {
                this.startElement(handler, XML_TAG_ALGORITHM);
                this.writeTag(handler, XML_TAG_TYPE, algorithm);
                this.endElement(handler, XML_TAG_ALGORITHM);
            }
            this.writeTag(handler, XML_TAG_NAME, this.name);
            this.writeTag(handler, XML_TAG_START, this.start);
            this.writeTag(handler, XML_TAG_END, this.end);
            this.writeBranches(handler);
            this.startElement(handler, XML_TAG_STEPS);
            this.writeMboxes(handler);
            this.writeOffers(handler, (MultiMap)mboxNameToExperience, allExperienceNames);
            this.writeConversionStep(handler);
            this.endElement(handler, XML_TAG_STEPS);
            this.endElement(handler, XML_TAG_CAMPAIGN);
            handler.endDocument();
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeOffers(TransformerHandler handler, MultiMap mboxNameToExperience, List<String> allExperienceNames) throws SAXException {
        if (mboxNameToExperience.isEmpty()) {
            return;
        }
        this.startElement(handler, XML_TAG_STEP);
        this.writeTag(handler, XML_TAG_TYPE, XML_TAG_DISPLAY);
        this.startElement(handler, XML_TAG_LOCATIONS);
        for (Object mboxNameEntryAsObject : mboxNameToExperience.entrySet()) {
            Map.Entry mboxNameEntry = (Map.Entry)mboxNameEntryAsObject;
            String mboxName = (String)mboxNameEntry.getKey();
            Collection mboxExperiences = (Collection)mboxNameEntry.getValue();
            this.startElement(handler, XML_TAG_LOCATION);
            this.startElement(handler, XML_TAG_MBOXES);
            this.startElement(handler, XML_TAG_MBOX);
            this.writeTag(handler, XML_TAG_NAME, mboxName);
            this.endElement(handler, XML_TAG_MBOX);
            this.endElement(handler, XML_TAG_MBOXES);
            this.startElement(handler, XML_TAG_DISPLAYS);
            HashMap<String, TestandtargetExperience> experiencesByName = new HashMap<String, TestandtargetExperience>();
            for (Object experienceAsObject : mboxExperiences) {
                TestandtargetExperience experience = (TestandtargetExperience)experienceAsObject;
                experiencesByName.put(experience.getName(), experience);
            }
            ArrayList<TestandtargetExperience> allExperiences = new ArrayList<TestandtargetExperience>();
            for (String experienceName : allExperienceNames) {
                TestandtargetExperience experience = (TestandtargetExperience)experiencesByName.get(experienceName);
                if (experience == null) {
                    experience = TestandtargetExperience.newSegmentBasedExperience(experienceName, new TestandtargetSegment[0]);
                    experience.addOffer(new TestandtargetOffer("---DEFAULT---", mboxName, "", true));
                }
                allExperiences.add(experience);
            }
            for (TestandtargetExperience experience : allExperiences) {
                this.startElement(handler, XML_TAG_DISPLAY);
                this.writeTag(handler, XML_TAG_BRANCH, this.trimToSize(experience.getName(), 20));
                this.startElement(handler, XML_TAG_OFFERS);
                for (TestandtargetOffer offer : experience.getOffers()) {
                    if (!mboxName.equals(offer.getMbox())) continue;
                    if (offer.isDefault()) {
                        this.startElement(handler, XML_TAG_OFFER);
                        this.writeTag(handler, XML_TAG_NAME, OFFER_NAME_DEFAULT_CONTENT);
                    } else if (offer.isNeedsCreating()) {
                        this.startElement(handler, XML_TAG_OFFER, XML_TAG_TYPE, "html");
                        this.writeTag(handler, XML_TAG_NAME, offer.getName());
                        this.writeCdataTag(handler, XML_TAG_CONTENT, this.toHtmlOfferString(offer.getContentDeliveryPath()));
                    } else {
                        this.startElement(handler, XML_TAG_OFFER);
                        this.writeTag(handler, XML_TAG_NAME, offer.getName());
                    }
                    this.endElement(handler, XML_TAG_OFFER);
                }
                this.endElement(handler, XML_TAG_OFFERS);
                this.endElement(handler, XML_TAG_DISPLAY);
            }
            this.endElement(handler, XML_TAG_DISPLAYS);
            this.endElement(handler, XML_TAG_LOCATION);
        }
        this.endElement(handler, XML_TAG_LOCATIONS);
        this.endElement(handler, XML_TAG_STEP);
    }

    private String toHtmlOfferString(String contentPath) {
        return String.format(HTML_CAMPAIGN_FORMAT, contentPath);
    }

    private void writeMboxes(TransformerHandler handler) throws SAXException {
        this.startElement(handler, XML_TAG_STEP);
        this.writeTag(handler, XML_TAG_TYPE, "entry");
        this.startElement(handler, XML_TAG_LOCATIONS);
        this.startElement(handler, XML_TAG_LOCATION);
        this.startElement(handler, XML_TAG_MBOXES);
        this.startElement(handler, XML_TAG_MBOX);
        this.writeTag(handler, XML_TAG_NAME, "** display mboxes **");
        this.endElement(handler, XML_TAG_MBOX);
        this.endElement(handler, XML_TAG_MBOXES);
        this.endElement(handler, XML_TAG_LOCATION);
        this.endElement(handler, XML_TAG_LOCATIONS);
        this.endElement(handler, XML_TAG_STEP);
    }

    private void writeBranches(TransformerHandler handler) throws SAXException {
        if (this.experiences.isEmpty()) {
            return;
        }
        this.startElement(handler, XML_TAG_BRANCHES);
        for (TestandtargetExperience experience : this.experiences) {
            this.startElement(handler, XML_TAG_BRANCH);
            this.writeTag(handler, XML_TAG_NAME, this.trimToSize(experience.getName(), 20));
            if (experience.getPercentageConstraint() != null) {
                this.startElement(handler, XML_TAG_PERCENT_CONSTRAINT);
                this.writeTag(handler, XML_TAG_PERCENT, experience.getPercentageConstraint().toString());
                this.endElement(handler, XML_TAG_PERCENT_CONSTRAINT);
            } else if (!experience.getSegments().isEmpty()) {
                this.startElement(handler, XML_TAG_PARAM_CONSTRAINTS);
                for (TestandtargetSegment segment : experience.getSegments()) {
                    this.startElement(handler, XML_TAG_PARAM_CONSTRAINT);
                    this.writeTag(handler, XML_TAG_PARAMETER_TYPE, "profile");
                    this.writeTag(handler, XML_TAG_NAME, segment.getName().replace('/', '.'));
                    this.writeTag(handler, XML_TAG_MATCHER_TYPE, segment.getOperator());
                    this.startElement(handler, XML_TAG_VALUES);
                    for (String value : segment.getValues()) {
                        this.writeTag(handler, XML_TAG_STRING, value);
                    }
                    this.endElement(handler, XML_TAG_VALUES);
                    this.endElement(handler, XML_TAG_PARAM_CONSTRAINT);
                }
                this.endElement(handler, XML_TAG_PARAM_CONSTRAINTS);
            }
            this.endElement(handler, XML_TAG_BRANCH);
        }
        this.endElement(handler, XML_TAG_BRANCHES);
    }

    private void writeConversionStep(TransformerHandler handler) throws SAXException {
        this.startElement(handler, XML_TAG_STEP);
        this.writeTag(handler, XML_TAG_NAME, "Conversion on click");
        this.writeTag(handler, XML_TAG_TYPE, "conversion");
        this.startElement(handler, XML_TAG_LOCATIONS);
        this.startElement(handler, XML_TAG_LOCATION);
        this.startElement(handler, XML_TAG_MBOXES);
        this.startElement(handler, XML_TAG_MBOX);
        this.writeTag(handler, XML_TAG_NAME, StringUtils.isBlank((String)this.conversionGoal) ? "** click from display mbox **" : this.conversionGoal);
        this.endElement(handler, XML_TAG_MBOX);
        this.endElement(handler, XML_TAG_MBOXES);
        this.endElement(handler, XML_TAG_LOCATION);
        this.endElement(handler, XML_TAG_LOCATIONS);
        this.endElement(handler, XML_TAG_STEP);
    }

    private String trimToSize(String name, int maxSize) {
        return StringUtils.left((String)name, (int)maxSize).trim();
    }

    private void writeTag(TransformerHandler handler, String tagName, String tagValue) throws SAXException {
        handler.startElement("", tagName, tagName, null);
        handler.characters(tagValue.toCharArray(), 0, tagValue.length());
        handler.endElement("", tagName, tagName);
    }

    private void writeCdataTag(TransformerHandler handler, String tagName, String tagValue) throws SAXException {
        handler.startElement("", tagName, tagName, null);
        handler.startCDATA();
        handler.characters(tagValue.toCharArray(), 0, tagValue.length());
        handler.endCDATA();
        handler.endElement("", tagName, tagName);
    }

    private void startElement(TransformerHandler handler, String tagName) throws SAXException {
        handler.startElement("", tagName, tagName, null);
    }

    private void startElement(TransformerHandler handler, String tagName, String propertyName, String propertyValue) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", propertyName, propertyName, null, propertyValue);
        handler.startElement("", tagName, tagName, attr);
    }

    private void endElement(TransformerHandler handler, String tagName) throws SAXException {
        handler.endElement("", tagName, tagName);
    }

    public void addExperience(TestandtargetExperience tandtExperience) {
        this.experiences.add(tandtExperience);
    }

    public List<TestandtargetExperience> getExperiences() {
        return this.experiences;
    }

    public List<TestandtargetOffer> getOffers() {
        ArrayList<TestandtargetOffer> offers = new ArrayList<TestandtargetOffer>();
        for (TestandtargetExperience experience : this.experiences) {
            offers.addAll(experience.getOffers());
        }
        return offers;
    }

    public Set<String> getAllMboxLocations() {
        LinkedHashSet<String> mboxLocations = new LinkedHashSet<String>();
        for (TestandtargetOffer offer : this.getOffers()) {
            mboxLocations.add(offer.getMbox());
        }
        return mboxLocations;
    }
}

