/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.TestandtargetCampaignMediator;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.impl.TestandTargetCampaignType;
import com.day.cq.analytics.testandtarget.impl.TestandTargetConversionStyle;
import com.day.cq.analytics.testandtarget.impl.TestandTargetOperator;
import com.day.cq.analytics.testandtarget.impl.TestandtargetCampaign;
import com.day.cq.analytics.testandtarget.impl.TestandtargetExperience;
import com.day.cq.analytics.testandtarget.impl.TestandtargetOffer;
import com.day.cq.analytics.testandtarget.impl.TestandtargetSegment;
import com.day.cq.analytics.testandtarget.util.ExperiencePageFilter;
import com.day.cq.analytics.testandtarget.util.OfferHelper;
import com.day.cq.analytics.testandtarget.util.TeaserPageFilter;
import com.day.cq.commons.Filter;
import com.day.cq.personalization.Segment;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%cq.analytics.testandtargetcampaignmediator.name", description="%cq.analytics.testandtargetcampaignmediator.description")
@Service(value={TestandtargetCampaignMediator.class})
public class TestandtargetCampaignMediatorImpl
implements TestandtargetCampaignMediator {
    private static final Logger log = LoggerFactory.getLogger(TestandtargetCampaignMediatorImpl.class);
    private static final String DEFAULT_CONTENT_PATH = "/content/campaigns";
    @Property(value={"/content/campaigns"})
    private static final String CONTENT_PATH = "cq.analytics.testandtargetcampaignmediator.contentpath";
    @Reference
    private TestandtargetService testandtargetService;
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private String contentPath;

    protected void activate(ComponentContext context) {
        this.contentPath = OsgiUtil.toString(context.getProperties().get(CONTENT_PATH), (String)DEFAULT_CONTENT_PATH);
        log.info("{} started with contentPath {}", (Object)this.getClass().getSimpleName(), (Object)this.contentPath);
    }

    @Override
    public void syncAuthorCampaign(String campaignPath) throws RepositoryException, LoginException, TestandtargetException {
        this.syncCampaign(campaignPath, WCMMode.PREVIEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCampaign(String campaignPath, WCMMode wcmMode) throws LoginException, RepositoryException, TestandtargetException {
        if (!campaignPath.startsWith(this.contentPath)) {
            return;
        }
        String nameSuffix = wcmMode != WCMMode.DISABLED ? "author" : "";
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            CampaignContext context = this.getCampaignContext(adminResolver, campaignPath, nameSuffix);
            if (!context.isValid()) {
                log.debug("Not synchronizing page at path {} since it is not a valid campaign.", (Object)campaignPath);
                return;
            }
            Page campaignPage = context.getPage();
            String title = campaignPage.getTitle() + (nameSuffix.length() > 0 ? "_" + nameSuffix : "");
            Calendar start = campaignPage.getOnTime();
            Calendar end = campaignPage.getOffTime();
            String conversionStyle = (String)campaignPage.getProperties().get("conversionStyle", String.class);
            String conversionGoal = null;
            try {
                if (conversionStyle != null && TestandTargetConversionStyle.fromString(conversionStyle) == TestandTargetConversionStyle.NAME) {
                    conversionGoal = (String)campaignPage.getProperties().get("conversionGoalName", String.class);
                }
            }
            catch (RuntimeException e) {
                log.warn("Error retrieving the conversionStyle, falling back to default conversion goal", (Throwable)e);
            }
            TestandTargetCampaignType campaignType = TestandTargetCampaignType.fromString((String)campaignPage.getProperties().get("campaignType", String.class));
            String thirdPartyId = context.getThirdPartyId() + (nameSuffix.length() > 0 ? "/" + nameSuffix : "");
            Configuration configuration = context.getConfiguration();
            log.debug("Would create campaign with title {}, start {}, end {}, conversionGoal {}, campaignType {} .", new Object[]{title, start, end, conversionGoal, campaignType});
            TestandtargetCampaign campaign = new TestandtargetCampaign(title, start != null ? start.getTime() : null, end != null ? end.getTime() : null, conversionGoal, campaignType);
            Iterator experiences = campaignPage.listChildren((Filter)ExperiencePageFilter.INSTANCE);
            while (experiences.hasNext()) {
                Page experience = (Page)experiences.next();
                ValueMap properties = experience.getProperties();
                String segmentPath = (String)properties.get("cq:segments", String.class);
                if (segmentPath == null) {
                    log.warn("Experience page at {} does not have any segments defined, skippping.", (Object)experience.getPath());
                    continue;
                }
                TestandtargetExperience tandTExperience = this.createExperience(adminResolver, experience, segmentPath);
                if (tandTExperience == null) continue;
                Iterator offers = experience.listChildren((Filter)TeaserPageFilter.INSTANCE);
                while (offers.hasNext()) {
                    Page offerPage = (Page)offers.next();
                    TestandtargetOffer offer = new TestandtargetOffer(OfferHelper.getOfferName(offerPage.getPath()), OfferHelper.getOfferLocation(offerPage, wcmMode), offerPage.getPath());
                    tandTExperience.addOffer(offer);
                }
                if (tandTExperience.getOffers().isEmpty()) {
                    log.debug("Skipping experience at path {} since it has no offers.", (Object)experience.getPath());
                    continue;
                }
                campaign.addExperience(tandTExperience);
            }
            if (campaign.getExperiences().isEmpty()) {
                log.debug("Not saving campaign at path {} in Test & Target since no experiences were found", (Object)campaignPath);
                return;
            }
            TestandtargetExperience defaultExperience = TestandtargetExperience.newSegmentBasedExperience("Default", new TestandtargetSegment[0]);
            for (String mboxLocation : campaign.getAllMboxLocations()) {
                log.debug("Default experience : added offer for mbox location {}", (Object)mboxLocation);
                defaultExperience.addOffer(new TestandtargetOffer("---DEFAULT---", mboxLocation, "", true));
            }
            campaign.getExperiences().add(0, defaultExperience);
            this.detectOffersToCreate(configuration, campaign);
            this.testandtargetService.saveCampaign(configuration, thirdPartyId, campaign);
            this.testandtargetService.setCampaignState(configuration, "Approved", null, thirdPartyId);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    private TestandtargetExperience createExperience(ResourceResolver adminResolver, Page experience, String segmentPath) {
        Resource segmentResource = adminResolver.getResource(segmentPath);
        if (segmentResource == null) {
            log.warn("Dangling segment path {} for experience at {}", (Object)segmentPath, (Object)experience.getPath());
            return null;
        }
        Segment segment = (Segment)segmentResource.adaptTo(Segment.class);
        if (segment == null) {
            log.warn("Unable to adapt resource at {} to {}", (Object)segmentPath, (Object)Segment.class.getSimpleName());
            return null;
        }
        log.debug("Found segment {} at path {}", (Object)segment, (Object)segmentPath);
        switch (segment.getKind()) {
            case Direct: {
                TestandtargetSegment tandSegment = new TestandtargetSegment(segment.getName(), TestandTargetOperator.getTestandTargetOperator(segment.getOperator()), segment.getValue());
                return TestandtargetExperience.newSegmentBasedExperience(experience.getTitle(), tandSegment);
            }
            case And: {
                ArrayList<TestandtargetSegment> segments = new ArrayList<TestandtargetSegment>();
                this.processAndSegments(segment, segments);
                if (segments.isEmpty()) {
                    log.warn("No valid T&T segments can be extracted from segment at {}", (Object)segmentPath);
                    return null;
                }
                TestandtargetSegment percentileSegment = null;
                for (TestandtargetSegment childSegment : segments) {
                    if (!"percentile".equals(childSegment.getName())) continue;
                    percentileSegment = childSegment;
                    break;
                }
                if (percentileSegment != null) {
                    int percentageConstraint;
                    if (segments.size() != 1) {
                        log.warn("Segment at path {} has one percentile segment and at least one other segment. This combination is not supported by Test&Target, so skipping", (Object)segmentPath);
                    }
                    if ((percentageConstraint = this.evaluatePercentileSegment(segmentPath, percentileSegment)) == 0) {
                        log.warn("Found percentile segment at path {} whose percentageConstraints evaluates to {}, skipping.", (Object)segmentPath, (Object)percentageConstraint);
                        return null;
                    }
                    return TestandtargetExperience.newPercentageBasedExperience(experience.getTitle(), percentageConstraint);
                }
                return TestandtargetExperience.newSegmentBasedExperience(experience.getTitle(), segments.toArray(new TestandtargetSegment[0]));
            }
        }
        log.warn("Unable to handle segment of kind {} at path {} ( {} )", new Object[]{segment.getKind(), segmentPath, segment});
        return null;
    }

    private int evaluatePercentileSegment(String segmentPath, TestandtargetSegment percentileSegment) {
        int percentageConstraint = 0;
        try {
            for (String percentileEntry : percentileSegment.getValues()) {
                String[] range = percentileEntry.split("-");
                if (range.length != 2) continue;
                int start = Integer.parseInt(range[0]);
                int end = Integer.parseInt(range[1]);
                percentageConstraint += end - start;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Failed parsing percentile segment at " + segmentPath, (Throwable)e);
        }
        return percentageConstraint;
    }

    private void processAndSegments(Segment segment, List<TestandtargetSegment> segments) {
        block4: for (Segment subSegment : segment.getChildren()) {
            switch (subSegment.getKind()) {
                case Direct: {
                    log.debug("Adding subSegment {}", (Object)subSegment);
                    segments.add(new TestandtargetSegment(subSegment.getName(), TestandTargetOperator.getTestandTargetOperator(subSegment.getOperator()), subSegment.getValue()));
                    continue block4;
                }
                case And: {
                    log.debug("Recursing into subSegment {}", (Object)subSegment);
                    this.processAndSegments(subSegment, segments);
                    continue block4;
                }
            }
            log.warn("Not recursing into unhandled subSegment {}", (Object)subSegment);
        }
    }

    private void detectOffersToCreate(Configuration configuration, TestandtargetCampaign campaign) throws TestandtargetException {
        for (TestandtargetOffer offer : campaign.getOffers()) {
            if (offer.isDefault()) continue;
            try {
                log.debug("Verifying if offer {} exists in T&T ...", (Object)offer.getName());
                this.testandtargetService.getHTMLOffer(configuration, offer.getName());
                log.debug("Offer {} found in T&T.", (Object)offer.getName());
            }
            catch (TestandtargetException e) {
                offer.setNeedsCreating(true);
                log.debug("Offer {} not found in T&T ( error message from API : {} ).", (Object)offer.getName(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public void syncPublishCampaign(String campaignPath) throws RepositoryException, LoginException, TestandtargetException {
        this.syncCampaign(campaignPath, WCMMode.DISABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivatePublishCampaign(String campaignPath) throws LoginException, RepositoryException, TestandtargetException {
        if (!campaignPath.startsWith(this.contentPath)) {
            return;
        }
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            CampaignContext context = this.getCampaignContext(adminResolver, campaignPath, "");
            if (!context.isValid()) {
                return;
            }
            this.testandtargetService.setCampaignState(context.getConfiguration(), "Deactivated", null, context.getThirdPartyId());
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    private CampaignContext getCampaignContext(ResourceResolver adminResolver, String campaignPath, String nameSuffix) throws PathNotFoundException, RepositoryException {
        PageManager pageManager = (PageManager)adminResolver.adaptTo(PageManager.class);
        Page page = OfferHelper.getCampaign(pageManager.getPage(campaignPath));
        if (page == null) {
            log.warn("Page at path {} is not part of a campaign.", (Object)campaignPath);
            return CampaignContext.INVALID;
        }
        Node contentNode = (Node)page.getContentResource().adaptTo(Node.class);
        String slingResourceType = contentNode.getProperty("sling:resourceType").getString();
        if (!"cq/personalization/components/campaignpage".equals(slingResourceType)) {
            log.debug("Skipping page at {} since its resourceType {} does not match {}", new Object[]{campaignPath, slingResourceType, "cq/personalization/components/campaignpage"});
            return CampaignContext.INVALID;
        }
        Configuration configuration = null;
        if (contentNode.hasProperty("cq:cloudserviceconfigs")) {
            configuration = this.configurationManager.getConfiguration(contentNode.getProperty("cq:cloudserviceconfigs").getString());
        }
        if (configuration == null) {
            log.warn("Unable to process campaign page at {} since no configuration was found for it.", (Object)campaignPath);
            return CampaignContext.INVALID;
        }
        String thirdPartyId = OfferHelper.getThirdPartyCampaignId(contentNode);
        return new CampaignContext(thirdPartyId, configuration, page);
    }

    protected void bindTestandtargetService(TestandtargetService testandtargetService) {
        this.testandtargetService = testandtargetService;
    }

    protected void unbindTestandtargetService(TestandtargetService testandtargetService) {
        if (this.testandtargetService == testandtargetService) {
            this.testandtargetService = null;
        }
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    private static class CampaignContext {
        static CampaignContext INVALID = new CampaignContext(null, null, null);
        private final String thirdPartyId;
        private final Configuration configuration;
        private final Page page;

        public CampaignContext(String thirdPartyId, Configuration configuration, Page page) {
            this.thirdPartyId = thirdPartyId;
            this.configuration = configuration;
            this.page = page;
        }

        public boolean isValid() {
            return this.thirdPartyId != null && this.configuration != null;
        }

        public String getThirdPartyId() {
            return this.thirdPartyId;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

