/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.impl.TestandtargetOffer;
import com.day.cq.analytics.testandtarget.impl.TestandtargetSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestandtargetExperience {
    private final String name;
    private final List<TestandtargetSegment> segments;
    private final Integer percentageConstraint;
    private final List<TestandtargetOffer> offers = new ArrayList<TestandtargetOffer>();

    public static TestandtargetExperience newSegmentBasedExperience(String name, TestandtargetSegment ... segments) {
        return new TestandtargetExperience(name, null, segments);
    }

    public static TestandtargetExperience newPercentageBasedExperience(String name, Integer percentageConstraint) {
        return new TestandtargetExperience(name, percentageConstraint, new TestandtargetSegment[0]);
    }

    public static TestandtargetExperience newDefaultExperience() {
        return new TestandtargetExperience("Default", null, new TestandtargetSegment[0]);
    }

    private TestandtargetExperience(String name, Integer percentage, TestandtargetSegment ... segments) {
        this.name = name;
        this.segments = new ArrayList<TestandtargetSegment>(Arrays.asList(segments));
        this.percentageConstraint = percentage;
    }

    public void addOffer(TestandtargetOffer offer) {
        this.offers.add(offer);
    }

    public String getName() {
        return this.name;
    }

    public List<TestandtargetSegment> getSegments() {
        return this.segments;
    }

    public List<TestandtargetOffer> getOffers() {
        return this.offers;
    }

    public Integer getPercentageConstraint() {
        return this.percentageConstraint;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.getName();
    }
}

