/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.analytics.testandtarget.TestandtargetHttpClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Dictionary;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.analytics.testandtarget.restclient.name", description="%cq.analytics.testandtarget.restclient.description")
@Service
@Properties(value={@Property(name="service.description", value={"Test&Target HTTP Client"})})
public class TestandtargetHttpClientImpl
implements TestandtargetHttpClient {
    private static final Logger log = LoggerFactory.getLogger(TestandtargetHttpClientImpl.class);
    private static final int DEFAULT_TIMEOUT = 60000;
    @Property(name="cq.analytics.testandtarget.api.url", value={"https://admin.testandtarget.omniture.com/api"})
    private static final String API_URL = "cq.analytics.testandtarget.api.url";
    @Property(intValue={60000})
    private static final String TIMEOUT = "cq.analytics.testandtarget.timeout";
    private static String DEFAULT_API_URL = "https://admin.testandtarget.omniture.com/api";
    private String apiUrl;
    private int timeout;

    public String execute(String[] queryKeys, String[] queryValues) throws TestandtargetException {
        GetMethod request = null;
        HttpClient http = new HttpClient();
        HttpClientParams params = http.getParams();
        params.setSoTimeout(this.timeout);
        try {
            HttpsURL url = this.apiUrl.startsWith("https") ? new HttpsURL(this.apiUrl) : new HttpURL(this.apiUrl);
            url.setQuery(queryKeys, queryValues);
            request = new GetMethod(url.toString());
            int statusCode = http.executeMethod((HttpMethod)request);
            if (statusCode > 399 && statusCode < 600) {
                log.warn("Test&Target HTTP call returned status code " + statusCode);
            }
            String string = this.consumeResponse((HttpMethod)request);
            return string;
        }
        catch (Exception e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private String consumeResponse(HttpMethod method) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader responseReader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
        while ((line = responseReader.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    @Activate
    protected void activate(ComponentContext componentContext) throws RepositoryException {
        Dictionary properties = componentContext.getProperties();
        this.apiUrl = OsgiUtil.toString(properties.get(API_URL), (String)DEFAULT_API_URL);
        this.timeout = OsgiUtil.toInteger(properties.get(TIMEOUT), (int)60000);
        log.debug("Started with apiUrl {} and timeout {} ms", (Object)this.apiUrl, (Object)this.timeout);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        log.debug("Stopped", (Object)TestandtargetHttpClientImpl.class.getSimpleName());
    }
}

