/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.day.cq.analytics.testandtarget.Conversion;
import com.day.cq.analytics.testandtarget.Folder;
import com.day.cq.analytics.testandtarget.HTMLOffer;
import com.day.cq.analytics.testandtarget.Offer;
import com.day.cq.analytics.testandtarget.Recipe;
import com.day.cq.analytics.testandtarget.Report;
import com.day.cq.analytics.testandtarget.ReportType;
import com.day.cq.analytics.testandtarget.Reports;
import com.day.cq.analytics.testandtarget.Resolution;
import com.day.cq.analytics.testandtarget.Sample;
import com.day.cq.analytics.testandtarget.Step;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestandtargetResponse {
    private static final String NODE_ERROR = "error";
    private static final String NODE_MESSAGE = "message";
    private static final String NODE_OPERATION = "operation";
    private static final String NODE_CAUSE = "cause";
    private static final String NODE_CODE = "code";
    private static final String NODE_THIRDPARTYID = "third-party-id";
    private String response;
    private Document document;
    private Element root;

    public TestandtargetResponse(String response) throws TestandtargetException {
        try {
            InputSource is = new InputSource(new StringReader(response));
            this.response = response;
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            this.root = this.document.getDocumentElement();
        }
        catch (Exception e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
    }

    public boolean isSuccess() {
        try {
            boolean isOperationFail;
            boolean bl = isOperationFail = NODE_OPERATION.equals(this.root.getNodeName()) && "FAIL".equals(this.getElement(this.root, "status", true).getTextContent());
            return !NODE_ERROR.equals(this.root.getNodeName()) && !isOperationFail;
        }
        catch (TestandtargetException e) {
            return false;
        }
    }

    public String getCode() {
        try {
            Element code = this.getElement(this.root, NODE_CODE, true);
            return code.getTextContent();
        }
        catch (TestandtargetException e) {
            return null;
        }
    }

    public String getErrorMessage() {
        try {
            if (NODE_ERROR.equals(this.root.getNodeName())) {
                Element message = this.getElement(this.root, NODE_MESSAGE, true);
                return message.getTextContent();
            }
            Element cause = this.getElement(this.root, NODE_CAUSE, true);
            return cause.getTextContent();
        }
        catch (TestandtargetException e) {
            return null;
        }
    }

    public String getThirdPartyId() {
        try {
            Element thirdpartid = this.getElement(this.root, NODE_THIRDPARTYID, true);
            return thirdpartid.getTextContent();
        }
        catch (TestandtargetException e) {
            return null;
        }
    }

    public String getResponse() {
        return this.response;
    }

    public Folder getFolderList() {
        try {
            return this.getFolder(this.root);
        }
        catch (TestandtargetException e) {
            return null;
        }
    }

    private Folder getFolder(Element parent) throws TestandtargetException {
        Element name = this.getElement(parent, "name", true);
        Element id = this.getElement(parent, "id", true);
        Element folders = this.getElement(parent, "folders", false);
        Folder folder = new Folder(name.getTextContent(), id.getTextContent());
        if (folders != null) {
            NodeList childs = folders.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node childNode = childs.item(i);
                if (1 != childNode.getNodeType()) continue;
                Element child = (Element)childNode;
                folder.add(this.getFolder(child));
            }
        }
        return folder;
    }

    public Collection<Offer> getOfferList() {
        ArrayList<Offer> offers = new ArrayList<Offer>();
        NodeList offerNodes = this.root.getChildNodes();
        for (int i = 0; i < offerNodes.getLength(); ++i) {
            Node child = offerNodes.item(i);
            if (1 != child.getNodeType()) continue;
            try {
                Element o = (Element)child;
                Element name = this.getElement(o, "name", true);
                Element id = this.getElement(o, "id", true);
                offers.add(new Offer(name.getTextContent(), id.getTextContent()));
                continue;
            }
            catch (TestandtargetException e) {
                // empty catch block
            }
        }
        return offers;
    }

    public HTMLOffer getHTMLOffer() {
        try {
            Element htmlOffer = this.getElement(this.root, "htmlOffer", true);
            Element script = this.getElement(htmlOffer, "", false);
            Element value = this.getElement(htmlOffer, "value", true);
            return new HTMLOffer(script.getTextContent(), value.getTextContent());
        }
        catch (TestandtargetException e) {
            return null;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRootNode() {
        return this.root;
    }

    public Element getElement(Element parent, String name, boolean required) throws TestandtargetException {
        NodeList children = parent.getChildNodes();
        Element found = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            found = (Element)child;
        }
        if (required && found == null) {
            throw new TestandtargetException("Element " + name + " not found in " + parent.getNodeName() + ".");
        }
        return found;
    }

    public String getAttribute(Element element, String name) throws TestandtargetException {
        Attr attribute = element.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new TestandtargetException("Attribute " + name + " not found in " + element.getNodeName() + ".");
    }

    public Reports getReports() throws TestandtargetException {
        try {
            SimpleDateFormat shortDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Reports reports = new Reports();
            NodeList reportNodes = this.root.getElementsByTagName("report");
            for (int i = 0; i < reportNodes.getLength(); ++i) {
                this.parseReport(reports, (Element)reportNodes.item(i), shortDateFormat);
            }
            return reports;
        }
        catch (ParseException e) {
            throw new TestandtargetException("Failed parsing response", e);
        }
    }

    private void parseReport(Reports reports, Element reportElement, DateFormat shortDateFormat) throws TestandtargetException, ParseException {
        String campaignId = this.getAttribute(reportElement, "campaignId");
        Date start = shortDateFormat.parse(this.getAttribute(reportElement, "start"));
        Date end = shortDateFormat.parse(this.getAttribute(reportElement, "end"));
        Resolution resolution = Resolution.fromTestandTargetKey(this.getAttribute(reportElement, "resolution"));
        ReportType reportType = ReportType.fromTestandTargetKey(this.getAttribute(reportElement, "type"));
        Report report = new Report(campaignId, start, end, resolution, reportType);
        reports.addReport(report);
        NodeList sampleNodes = reportElement.getElementsByTagName("sample");
        for (int i = 0; i < sampleNodes.getLength(); ++i) {
            this.parseSample(report, (Element)sampleNodes.item(i), shortDateFormat, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"));
        }
    }

    private void parseSample(Report report, Element sampleElement, DateFormat shortDateFormat, DateFormat longDateFormat) throws TestandtargetException, ParseException {
        Resolution duration = Resolution.fromTestandTargetKey(this.getAttribute(sampleElement, "duration"));
        Date start = longDateFormat.parse(this.getAttribute(sampleElement, "start"));
        Sample sample = new Sample(start, duration);
        report.addSample(sample);
        NodeList recipeNodes = sampleElement.getElementsByTagName("recipe");
        for (int i = 0; i < recipeNodes.getLength(); ++i) {
            this.parseRecipe(sample, (Element)recipeNodes.item(i), shortDateFormat, longDateFormat);
        }
    }

    private void parseRecipe(Sample sample, Element recipeElement, DateFormat shortDateFormat, DateFormat longDateFormat) throws TestandtargetException {
        String id = this.getAttribute(recipeElement, "id");
        String name = this.getAttribute(recipeElement, "name");
        String trafficType = this.getAttribute(recipeElement, "trafficType");
        Conversion conversion = this.parseConversion(this.getElement(recipeElement, "conversion", false));
        Recipe recipe = new Recipe(id, name, trafficType, conversion);
        sample.addRecipe(recipe);
        NodeList stepNodes = recipeElement.getElementsByTagName("step");
        for (int i = 0; i < stepNodes.getLength(); ++i) {
            this.parseStep(recipe, (Element)stepNodes.item(i));
        }
    }

    private Conversion parseConversion(Element recipeElement) throws DOMException, TestandtargetException {
        if (recipeElement == null) {
            return null;
        }
        String name = this.getAttribute(recipeElement, "name");
        BigDecimal value = new BigDecimal(this.getElement(recipeElement, "count", true).getTextContent());
        return new Conversion(name, value);
    }

    private void parseStep(Recipe recipe, Element stepItem) throws TestandtargetException {
        String name = this.getAttribute(stepItem, "name");
        BigDecimal value = new BigDecimal(this.getElement(stepItem, "count", true).getTextContent());
        recipe.addStep(new Step(name, value));
    }
}

