/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.analytics.testandtarget.Folder;
import com.day.cq.analytics.testandtarget.HTMLOffer;
import com.day.cq.analytics.testandtarget.Offer;
import com.day.cq.analytics.testandtarget.ReportType;
import com.day.cq.analytics.testandtarget.Reports;
import com.day.cq.analytics.testandtarget.Resolution;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.analytics.testandtarget.TestandtargetHttpClient;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.impl.TestandtargetCampaign;
import com.day.cq.analytics.testandtarget.impl.TestandtargetResponse;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="%cq.analytics.testandtarget.service.name", description="%cq.analytics.testandtarget.service.description")
@Service
@Properties(value={@Property(name="service.description", value={"Test&Target Client Wrapper"})})
public class TestandtargetServiceImpl
implements TestandtargetService {
    static final String API_DATE_FORMAT_LONG = "yyyy-MM-dd'T'HH:mm";
    static final String API_DATE_FORMAT_SHORT = "yyyy-MM-dd";
    private static final Logger log = LoggerFactory.getLogger(TestandtargetServiceImpl.class);
    private static final String VERSION = "1";
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private TestandtargetHttpClient client;

    @Override
    public Folder listFolders(Configuration configuration) throws TestandtargetException {
        HashMap<String, String> queryParameter = this.getInitialParameters(configuration, "folderList");
        queryParameter.put("version", VERSION);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameter));
        if (response.isSuccess()) {
            return response.getFolderList();
        }
        throw new TestandtargetException(this.getResponseErrorMessage(response));
    }

    void buildTree(Node folder, JSONObject json) throws TestandtargetException {
        try {
            Node name = folder.getFirstChild().getNextSibling();
            Node id = name.getNextSibling().getNextSibling();
            Node folders = id.getNextSibling().getNextSibling();
            NodeList flds = folders.getChildNodes();
            json.put("text", (Object)name.getTextContent());
            json.put("id", (Object)id.getTextContent());
            json.put("leaf", flds.getLength() == 0);
            if (flds.getLength() > 0) {
                JSONArray childs = new JSONArray();
                for (int i = 0; i < flds.getLength(); ++i) {
                    JSONObject child = new JSONObject();
                    Node f = flds.item(i);
                    if (3 == f.getNodeType()) continue;
                    this.buildTree(f, child);
                    childs.put((Object)child);
                }
                json.put("children", (Object)childs);
            }
        }
        catch (JSONException e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
    }

    @Override
    public void createHTMLOffer(Configuration configuration, String offerName, String folderId, String content) throws TestandtargetException {
        HashMap<String, String> queryParameter = this.getInitialParameters(configuration, "saveHtmlOfferContent");
        queryParameter.put("version", VERSION);
        queryParameter.put("offerName", offerName);
        queryParameter.put("folderId", folderId);
        queryParameter.put("content", content);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameter));
        if (!response.isSuccess()) {
            throw new TestandtargetException(this.getResponseErrorMessage(response));
        }
    }

    @Override
    public HTMLOffer getHTMLOffer(Configuration configuration, String offerName) throws TestandtargetException {
        HashMap<String, String> queryParameter = this.getInitialParameters(configuration, "getHtmlOfferContent");
        queryParameter.put("version", VERSION);
        queryParameter.put("offerName", offerName);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameter));
        if (response.isSuccess()) {
            return response.getHTMLOffer();
        }
        throw new TestandtargetException(this.getResponseErrorMessage(response));
    }

    @Override
    public Collection<Offer> listOffers(Configuration configuration, String folderId) throws TestandtargetException {
        HashMap<String, String> queryParameter = this.getInitialParameters(configuration, "offerList");
        queryParameter.put("version", VERSION);
        queryParameter.put("folderId", folderId);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameter));
        if (response.isSuccess()) {
            return response.getOfferList();
        }
        throw new TestandtargetException(this.getResponseErrorMessage(response));
    }

    @Override
    public String publishOffer(Configuration configuration, String name, String url, String id) throws TestandtargetException {
        return this.widgetOfferOperation(configuration, name, url, id, "saveWidgetOffer");
    }

    @Override
    public String unpublishOffer(Configuration configuration, String name, String url, String id) throws TestandtargetException {
        return this.widgetOfferOperation(configuration, name, url, id, "deleteWidgetOffer");
    }

    @Override
    public String createWidgetOffer(Configuration configuration, String name, String url, String id) throws TestandtargetException {
        return this.widgetOfferOperation(configuration, name, url, id, "saveWidgetOffer");
    }

    private String widgetOfferOperation(Configuration configuration, String name, String url, String id, String operation) throws TestandtargetException {
        HashMap<String, String> queryParameter = this.getInitialParameters(configuration, operation);
        if (name != null) {
            queryParameter.put("name", name);
        }
        if (url != null) {
            queryParameter.put("url", url);
        }
        queryParameter.put("id", id);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameter));
        if (response.isSuccess()) {
            String thirdPartyId = response.getThirdPartyId();
            if (thirdPartyId != null) {
                return thirdPartyId;
            }
            return null;
        }
        throw new TestandtargetException(this.getResponseErrorMessage(response));
    }

    @Override
    public Map<Integer, String> listCampaigns(Configuration configuration, Date before, Date after, String environment, String name, String state, String label) throws TestandtargetException {
        return this.listCampaigns((String)configuration.getInherited("clientcode", (Object)""), (String)configuration.getInherited("email", (Object)""), this.getPassword(configuration), before, after, environment, name, state, label);
    }

    private Map<Integer, String> listCampaigns(String clientcode, String email, String password, Date before, Date after, String environment, String name, String state, String label) throws TestandtargetException {
        TestandtargetResponse response;
        DateFormat sdf = this.newDateFormat();
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("client", clientcode);
        queryParameter.put("email", email);
        queryParameter.put("password", password);
        queryParameter.put("operation", "campaignList");
        queryParameter.put("before", before != null ? sdf.format(before) : sdf.format(new Date()));
        if (after != null) {
            queryParameter.put("after", sdf.format(after));
        }
        if (this.isNotEmpty(environment)) {
            queryParameter.put("environment", environment);
        }
        if (this.isNotEmpty(name)) {
            queryParameter.put("name", name);
        }
        if (this.isNotEmpty(state)) {
            queryParameter.put("state", state);
        }
        if (this.isNotEmpty(label)) {
            queryParameter.put("label", label);
        }
        if ((response = new TestandtargetResponse(this.execute(queryParameter))).isSuccess()) {
            HashMap<Integer, String> campaigns = new HashMap<Integer, String>();
            Document doc = response.getDocument();
            Element root = response.getRootNode();
            if ("campaigns".equals(root.getNodeName()) && doc.getElementsByTagName("campaign").getLength() > 0) {
                NodeList nodes = doc.getElementsByTagName("campaign");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String id = nodes.item(i).getFirstChild().getFirstChild().getNodeValue();
                    String campaignname = nodes.item(i).getFirstChild().getNextSibling().getFirstChild().getNodeValue();
                    campaigns.put(Integer.parseInt(id), campaignname);
                }
            }
            return campaigns;
        }
        throw new TestandtargetException(this.getResponseErrorMessage(response));
    }

    private DateFormat newDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(API_DATE_FORMAT_LONG);
        dateFormat.setTimeZone(TimeZone.getTimeZone("Etc/GMT"));
        return dateFormat;
    }

    @Override
    public boolean setCampaignState(Configuration configuration, String campaignState, String testAndTargetCampaignId, String thirdPartyCampaignId) throws TestandtargetException {
        HashMap<String, String> queryParameter = this.getInitialParameters(configuration, "setCampaignState");
        queryParameter.put("state", campaignState);
        if (testAndTargetCampaignId != null) {
            queryParameter.put("campaignId", testAndTargetCampaignId);
        } else {
            queryParameter.put("thirdPartyId", thirdPartyCampaignId);
        }
        log.debug("Calling T&T API with query parameters {}", queryParameter);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameter));
        log.debug("Got T&T API response {}", (Object)response.getResponse());
        if (response.isSuccess()) {
            return true;
        }
        throw new TestandtargetException(this.getResponseErrorMessage(response));
    }

    @Override
    public void saveCampaign(Configuration configuration, String thirdPartyId, TestandtargetCampaign campaign) throws TestandtargetException {
        HashMap<String, String> queryParameters = this.getInitialParameters(configuration, "saveCampaign");
        queryParameters.put("thirdPartyId", thirdPartyId);
        queryParameters.put("campaign", campaign.asXml());
        log.debug("Calling T&T API with thirdPartyId {} and campaign XML {}", (Object)thirdPartyId, (Object)campaign.asXml());
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameters));
        log.debug("Got T&T API response {}", (Object)response.getResponse());
        if (!response.isSuccess()) {
            throw new TestandtargetException(this.getResponseErrorMessage(response));
        }
    }

    @Override
    public void checkCredentials(String email, String password, String clientcode) throws TestandtargetException {
        this.listCampaigns(email, password, clientcode, null, null, null, "somedummyname", null, null);
    }

    @Override
    public Reports getPerformanceReport(Configuration configuration, ReportType reportType, String campaignId, String thirdPartyCampaignId, Date start, Date end, Resolution resolution) throws TestandtargetException {
        DateFormat dateFormat = this.newDateFormat();
        HashMap<String, String> queryParameters = this.getInitialParameters(configuration, "report");
        queryParameters.put("type", reportType.getTestandTargetKey());
        if (campaignId != null) {
            queryParameters.put("campaignId", campaignId);
        }
        if (thirdPartyCampaignId != null) {
            queryParameters.put("thirdPartyCampaignId", thirdPartyCampaignId);
        }
        queryParameters.put("start", dateFormat.format(start));
        queryParameters.put("end", dateFormat.format(end));
        queryParameters.put("resolution", resolution.getTestandTargetKey());
        queryParameters.put("version", "2");
        log.debug("Getting performance data for campaign with id {}", (Object)campaignId);
        TestandtargetResponse response = new TestandtargetResponse(this.execute(queryParameters));
        log.debug("Got T&T API response {}", (Object)response.getResponse());
        if (!response.isSuccess()) {
            throw new TestandtargetException(this.getResponseErrorMessage(response));
        }
        return response.getReports();
    }

    private String execute(Map<String, String> queryParameter) throws TestandtargetException {
        String[] queryKeys = queryParameter.keySet().toArray(new String[0]);
        String[] queryValues = queryParameter.values().toArray(new String[0]);
        return this.client.execute(queryKeys, queryValues);
    }

    private HashMap<String, String> getInitialParameters(Configuration configuration, String operation) throws TestandtargetException {
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("client", (String)configuration.getInherited("clientcode", (Object)""));
        queryParameter.put("email", (String)configuration.getInherited("email", (Object)""));
        queryParameter.put("password", this.getPassword(configuration));
        queryParameter.put("operation", operation);
        return queryParameter;
    }

    private String getPassword(Configuration configuration) throws TestandtargetException {
        try {
            String password = (String)configuration.getInherited("password", (Object)"");
            return this.cryptoSupport.isProtected(password) ? this.cryptoSupport.unprotect(password) : password;
        }
        catch (CryptoException e) {
            throw new TestandtargetException(e.getMessage(), e);
        }
    }

    private boolean isNotEmpty(String value) {
        return value != null && value.length() > 0;
    }

    private String getResponseErrorMessage(TestandtargetResponse response) {
        return response.getErrorMessage() != null ? response.getErrorMessage() : "Status code: " + response.getCode();
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindClient(TestandtargetHttpClient testandtargetHttpClient) {
        this.client = testandtargetHttpClient;
    }

    protected void unbindClient(TestandtargetHttpClient testandtargetHttpClient) {
        if (this.client == testandtargetHttpClient) {
            this.client = null;
        }
    }
}

