/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets;

import com.day.cq.analytics.testandtarget.TestandtargetCommand;
import com.day.cq.commons.servlets.AbstractCommandServlet;
import com.day.cq.commons.servlets.HtmlStatusResponseHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.HtmlResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="%cq.analytics.testandtarget.servlet.name", description="%cq.analytics.testandtarget.servlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/analytics/testandtarget/command"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class CommandServlet
extends AbstractCommandServlet {
    private static final Logger log = LoggerFactory.getLogger(CommandServlet.class);
    private Map<String, TestandtargetCommand> commands = new HashMap<String, TestandtargetCommand>();
    private ServiceTracker commandTracker;
    private int commandTrackerCount;

    protected boolean hasCommand(SlingHttpServletRequest request) throws ServletException {
        this.registerCommandsIfNeeded();
        String action = request.getParameter("cmd");
        return this.commands.containsKey(action);
    }

    protected void performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            this.registerCommandsIfNeeded();
            String action = request.getParameter("cmd");
            HtmlResponse htmlResponse = null;
            TestandtargetCommand cmd = this.commands.get(action);
            htmlResponse = cmd != null ? cmd.performCommand(request, response) : HtmlStatusResponseHelper.createStatusResponse((boolean)false, (String)("Unknown action " + action));
            if (htmlResponse != null) {
                htmlResponse.send((HttpServletResponse)response, false);
            }
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommandsIfNeeded() {
        if (this.commandTrackerCount != this.commandTracker.getTrackingCount()) {
            this.commandTrackerCount = this.commandTracker.getTrackingCount();
            ArrayList<TestandtargetCommand> tntCommands = new ArrayList<TestandtargetCommand>();
            for (ServiceReference svc : this.commandTracker.getServiceReferences()) {
                tntCommands.add((TestandtargetCommand)this.commandTracker.getService(svc));
            }
            ArrayList<TestandtargetCommand> arrayList = tntCommands;
            synchronized (arrayList) {
                this.commands.clear();
                for (TestandtargetCommand cmd : tntCommands) {
                    this.addCommand(cmd);
                }
            }
            log.info("TestandtargetCommand tracker count changed, list rebuilt with {} commands: [{}]", (Object)this.commands.size(), this.commands.keySet());
        }
    }

    protected void addCommand(TestandtargetCommand cmd) {
        this.commands.put(cmd.getName(), cmd);
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.commandTrackerCount = -1;
        this.commandTracker = new ServiceTracker(context.getBundleContext(), TestandtargetCommand.class.getName(), null);
        this.commandTracker.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.commandTracker.close();
        this.commandTracker = null;
        this.commands.clear();
    }
}

