/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets;

import com.day.cq.analytics.testandtarget.Folder;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/analytics/testandtarget/folderlist"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class FolderListServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(FolderListServlet.class);
    private static final String PARAM_PATH = "cfgpath";
    @Reference
    private TestandtargetService service;
    @Reference
    private ConfigurationManager cfgMgr;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        try {
            Configuration config = this.cfgMgr.getConfiguration(request.getParameter(PARAM_PATH));
            if (config != null) {
                Folder folder = this.service.listFolders(config);
                JSONArray result = new JSONArray();
                JSONObject folders = this.getFolderJSON(folder);
                result.put((Object)folders);
                out.write(result.toString());
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    private JSONObject getFolderJSON(Folder folder) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("text", (Object)folder.getName());
        json.put("id", (Object)folder.getId());
        json.put("leaf", !folder.getChildren().hasNext());
        JSONArray children = new JSONArray();
        Iterator<Folder> it = folder.getChildren();
        while (it.hasNext()) {
            Folder subFolder = it.next();
            children.put((Object)this.getFolderJSON(subFolder));
        }
        if (children.length() > 0) {
            json.put("children", (Object)children);
        }
        return json;
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }

    protected void bindCfgMgr(ConfigurationManager configurationManager) {
        this.cfgMgr = configurationManager;
    }

    protected void unbindCfgMgr(ConfigurationManager configurationManager) {
        if (this.cfgMgr == configurationManager) {
            this.cfgMgr = null;
        }
    }
}

