/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets.commands;

import com.day.cq.analytics.testandtarget.TestandtargetCommand;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ConnectCommand
implements TestandtargetCommand {
    private static final Logger log = LoggerFactory.getLogger(ConnectCommand.class);
    @Reference
    private TestandtargetService service;

    public String getName() {
        return "connect";
    }

    public HtmlResponse performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter out = new JSONWriter((Writer)response.getWriter());
        try {
            String clientcode = request.getParameter("clientcode");
            String email = request.getParameter("email");
            String password = request.getParameter("password");
            this.service.checkCredentials(clientcode, email, password);
            out.object();
            out.key("success").value(true);
            out.endObject();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                out.object();
                out.key("error").value((Object)e.getMessage());
                out.endObject();
            }
            catch (JSONException je) {
                log.error(je.getMessage(), (Throwable)je);
            }
        }
        return null;
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }
}

