/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets.commands;

import com.day.cq.analytics.testandtarget.TestandtargetCommand;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.util.OfferHelper;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Node;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class DeleteWidgetOfferCommand
implements TestandtargetCommand {
    private static final Logger log = LoggerFactory.getLogger(DeleteWidgetOfferCommand.class);
    private static final String PARAM_CFG = "cfgpath";
    private static final String PARAM_PATH = "path";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private TestandtargetService service;

    public String getName() {
        return "deleteWidgetOffer";
    }

    public HtmlResponse performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String configPath = request.getParameter(PARAM_CFG);
        JSONWriter out = new JSONWriter((Writer)response.getWriter());
        try {
            Configuration config = null;
            if (configPath != null) {
                config = this.configurationManager.getConfiguration(configPath);
            }
            if (config == null) {
                String msg = I18n.get((HttpServletRequest)request, (String)"Configuration '{0}' not found", null, (Object[])new Object[]{configPath});
                out.object();
                out.key("error").value((Object)msg);
                out.endObject();
                return null;
            }
            String path = request.getParameter(PARAM_PATH);
            Resource resource = request.getResourceResolver().getResource(path + "/jcr:content");
            Node node = (Node)resource.adaptTo(Node.class);
            String thirdPartyId = OfferHelper.getThirdPartyID(node);
            this.service.unpublishOffer(config, null, null, thirdPartyId);
            if (node.hasProperty("ttThirdPartyId")) {
                node.getProperty("ttThirdPartyId").remove();
            }
            node.getSession().save();
            out.object();
            out.key("success").value((Object)thirdPartyId);
            out.endObject();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                out.object();
                out.key("error").value((Object)e.getMessage());
                out.endObject();
            }
            catch (JSONException je) {
                log.error(je.getMessage(), (Throwable)je);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(PrintWriter out, String propertyname, String msg) {
        JSONObject returnValue = new JSONObject();
        try {
            returnValue.put(propertyname, (Object)msg);
            out.write(returnValue.toString());
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }
}

