/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets.commands;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.analytics.testandtarget.HTMLOffer;
import com.day.cq.analytics.testandtarget.TestandtargetCommand;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.util.OfferHelper;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class GetHtmlOfferContentCommand
implements TestandtargetCommand {
    private static final Logger log = LoggerFactory.getLogger(GetHtmlOfferContentCommand.class);
    private static final String PARAM_CFG = "cfgpath";
    private static final String PARAM_PATH = "path";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private TestandtargetService service;
    @Reference
    private XSSAPI xssApi;

    public String getName() {
        return "getHtmlOfferContent";
    }

    public HtmlResponse performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String configPath = request.getParameter(PARAM_CFG);
        String path = request.getParameter(PARAM_PATH);
        JSONWriter out = new JSONWriter((Writer)response.getWriter());
        try {
            Configuration config = null;
            if (configPath != null) {
                config = this.configurationManager.getConfiguration(configPath);
            }
            if (config == null) {
                String msg = I18n.get((HttpServletRequest)request, (String)"Configuration [{}] not found", (String)"Cloud service configuration can not be found under provided path", (Object[])new Object[]{configPath});
                out.object();
                out.key("error").value((Object)msg);
                out.endObject();
                return null;
            }
            String offerName = OfferHelper.getOfferName(path);
            if (offerName != null) {
                HTMLOffer htmlOffer = this.service.getHTMLOffer(config, offerName);
                out.object();
                out.key("script").value((Object)this.xssApi.encodeForJSString(htmlOffer.getScript()));
                out.key("value").value((Object)this.xssApi.encodeForJSString(htmlOffer.getValue()));
                out.endObject();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                out.object();
                out.key("error").value((Object)e.getMessage());
                out.endObject();
            }
            catch (JSONException je) {
                log.error(je.getMessage(), (Throwable)je);
            }
        }
        return null;
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }

    protected void bindXssApi(XSSAPI xSSAPI) {
        this.xssApi = xSSAPI;
    }

    protected void unbindXssApi(XSSAPI xSSAPI) {
        if (this.xssApi == xSSAPI) {
            this.xssApi = null;
        }
    }
}

