/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets.commands;

import com.day.cq.analytics.testandtarget.Recipe;
import com.day.cq.analytics.testandtarget.Report;
import com.day.cq.analytics.testandtarget.ReportType;
import com.day.cq.analytics.testandtarget.Reports;
import com.day.cq.analytics.testandtarget.Resolution;
import com.day.cq.analytics.testandtarget.Sample;
import com.day.cq.analytics.testandtarget.TestandtargetCommand;
import com.day.cq.analytics.testandtarget.TestandtargetException;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.util.OfferHelper;
import com.day.cq.commons.Filter;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
public class GetPerformanceReportCommand
implements TestandtargetCommand {
    private static final Logger log = LoggerFactory.getLogger(GetPerformanceReportCommand.class);
    private static final String PARAM_CAMPAIGN_PATH = "campaignPath";
    private static final String PARAM_LOCATION = "location";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private TestandtargetService service;

    @Override
    public String getName() {
        return "getPerformanceReport";
    }

    @Override
    public HtmlResponse performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String campaignPath = request.getParameter(PARAM_CAMPAIGN_PATH);
        JSONWriter out = new JSONWriter((Writer)response.getWriter());
        String location = request.getParameter(PARAM_LOCATION);
        if (location == null) {
            location = "";
        }
        try {
            if (campaignPath == null) {
                this.outputJsonError(out, I18n.get((HttpServletRequest)request, (String)"Missing mandatory 'campaignPath' parameter"));
                return null;
            }
            Resource campaign = request.getResourceResolver().getResource(campaignPath);
            if (campaign == null) {
                this.outputJsonError(out, I18n.get((HttpServletRequest)request, (String)"No campaign found at path '{0}'", null, (Object[])new Object[]{campaignPath}));
                return null;
            }
            String cloudConfiguration = (String)((ValueMap)campaign.adaptTo(ValueMap.class)).get("jcr:content/cq:cloudserviceconfigs", String.class);
            if (cloudConfiguration == null) {
                this.outputJsonError(out, I18n.get((HttpServletRequest)request, (String)"Campaign '{0}' does not have a cloud configuration", null, (Object[])new Object[]{campaignPath}));
                return null;
            }
            Configuration config = this.configurationManager.getConfiguration(cloudConfiguration);
            if (config == null) {
                this.outputJsonError(out, I18n.get((HttpServletRequest)request, (String)"Configuration '{0}' not found", null, (Object[])new Object[]{cloudConfiguration}));
                return null;
            }
            String thirdPartyId = OfferHelper.getThirdPartyCampaignId(((Node)campaign.adaptTo(Node.class)).getNode("jcr:content"));
            Reports performanceReport = this.service.getPerformanceReport(config, ReportType.IMPRESSION, null, thirdPartyId, new Date(0L), new Date(), Resolution.MONTH);
            Map<String, String> offerPathsByName = this.buildPathsByName(campaign);
            Map<String, String> teaserThumbByPath = this.buildTeaserThumbnailByPaths(request, campaign, location);
            LinkedHashMap<String, PerformanceRow> rows = new LinkedHashMap<String, PerformanceRow>();
            PerformanceRow campaignRow = new PerformanceRow(null, campaign.getPath(), null, 0, 0);
            PerformanceRow defaultRow = new PerformanceRow(I18n.get((HttpServletRequest)request, (String)"Default experience"), campaign.getPath(), null, 0, 0);
            rows.put(String.valueOf(0), defaultRow);
            for (Report report : performanceReport.getReports()) {
                for (Sample sample : report.getSamples()) {
                    for (Recipe recipe : sample.getRecipes()) {
                        PerformanceRow row;
                        int impressions = recipe.getStepValueByName("Display mboxes");
                        int conversions = recipe.getConversionCount();
                        PerformanceRow performanceRow = row = "TESTING".equals(recipe.getTrafficType()) ? (PerformanceRow)rows.get(recipe.getId()) : campaignRow;
                        if (row == null) {
                            String path = offerPathsByName.get(recipe.getName());
                            row = new PerformanceRow(recipe.getName(), path, teaserThumbByPath.get(path), impressions, conversions);
                            rows.put(recipe.getId(), row);
                            continue;
                        }
                        row.add(impressions, conversions);
                    }
                }
            }
            out.object();
            out.key("impressions").value((long)campaignRow.getImpressions());
            out.key("conversions").value((long)campaignRow.getConversions());
            out.key("path").value((Object)campaignRow.getPath());
            JSONArray experiences = new JSONArray();
            for (PerformanceRow row : rows.values()) {
                JSONObject jsonRow = new JSONObject();
                jsonRow.put("name", (Object)row.getExperienceName());
                jsonRow.put("impressions", row.getImpressions());
                jsonRow.put("conversions", row.getConversions());
                jsonRow.put("path", (Object)row.getPath());
                jsonRow.put("thumbnail", (Object)row.getThumbnail());
                experiences.put((Object)jsonRow);
            }
            out.key("experiences").value((Object)experiences);
            out.endObject();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.outputJsonError(out, e.getMessage());
        }
        catch (TestandtargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.outputJsonError(out, I18n.get((HttpServletRequest)request, (String)"Error returned by the Test&Target API: {0}", null, (Object[])new Object[]{e.getMessage()}));
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.outputJsonError(out, e.getMessage());
        }
        return null;
    }

    private Map<String, String> buildPathsByName(Resource campaign) {
        HashMap<String, String> offerPathsByName = new HashMap<String, String>();
        Iterator experiencePages = ((Page)campaign.adaptTo(Page.class)).listChildren((Filter)new Filter<Page>(){

            public boolean includes(Page element) {
                return "cq/personalization/components/experiencepage".equals(element.getContentResource().getResourceType());
            }
        });
        while (experiencePages.hasNext()) {
            Page offerPage = (Page)experiencePages.next();
            String oldValue = offerPathsByName.put(offerPage.getTitle(), offerPage.getPath());
            if (oldValue == null) continue;
            log.warn("Two campaign pages with the same title found( {}, {} ), unable to match with experiences reported by T&T", (Object)oldValue, (Object)offerPage.getPath());
        }
        return offerPathsByName;
    }

    private Map<String, String> buildTeaserThumbnailByPaths(SlingHttpServletRequest request, Resource campaign, final String location) throws JSONException {
        HashMap<String, String> teaserThumbByPath = new HashMap<String, String>();
        Iterator experiences = ((Page)campaign.adaptTo(Page.class)).listChildren((Filter)new Filter<Page>(){

            public boolean includes(Page element) {
                return element.getContentResource().getResourceType().equals("cq/personalization/components/experiencepage");
            }
        });
        while (experiences.hasNext()) {
            Page experience = (Page)experiences.next();
            Iterator teasers = experience.listChildren((Filter)new Filter<Page>(){

                public boolean includes(Page element) {
                    return element.getContentResource().getResourceType().equals("cq/personalization/components/teaserpage") && ((String)element.getProperties().get(GetPerformanceReportCommand.PARAM_LOCATION, (Object)"")).equals(location);
                }
            });
            if (!teasers.hasNext()) continue;
            teaserThumbByPath.put(experience.getPath(), ((Page)teasers.next()).getPath() + ".thumb.100.140.png");
        }
        return teaserThumbByPath;
    }

    private void outputJsonError(JSONWriter out, String msg) {
        try {
            out.object();
            out.key("error").value((Object)msg);
            out.endObject();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }

    private static class PerformanceRow {
        private final String experienceName;
        private final String path;
        private final String thumbnail;
        private int impressions;
        private int conversions;

        public PerformanceRow(String experienceName, String path, String thumbnail, int impressions, int conversions) {
            this.experienceName = experienceName;
            this.path = path;
            this.thumbnail = thumbnail;
            this.impressions = impressions;
            this.conversions = conversions;
        }

        public void add(int impressions, int conversions) {
            this.impressions += impressions;
            this.conversions += conversions;
        }

        public String getExperienceName() {
            return this.experienceName;
        }

        public String getPath() {
            return this.path;
        }

        public String getThumbnail() {
            return this.thumbnail;
        }

        public int getConversions() {
            return this.conversions;
        }

        public int getImpressions() {
            return this.impressions;
        }
    }
}

