/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.impl.servlets.commands;

import com.day.cq.analytics.testandtarget.TestandtargetCommand;
import com.day.cq.analytics.testandtarget.TestandtargetService;
import com.day.cq.analytics.testandtarget.util.OfferHelper;
import com.day.cq.i18n.I18n;
import com.day.cq.retriever.RetrieverService;
import com.day.cq.retriever.RetrieverStorage;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@Component
@Service
public class SaveHTMLOfferContentCommand
implements TestandtargetCommand {
    private static final Logger log = LoggerFactory.getLogger(SaveHTMLOfferContentCommand.class);
    private static final String PARAM_CFG = "cfgpath";
    private static final String PARAM_PATH = "path";
    private static final String PARAM_FOLDERID = "folderid";
    private static final String PARAM_CONTENT = "content";
    public static final String PN_LASTPUBLISHED = "cq:tntLastPublished";
    public static final String PN_FOLDERID = "cq:tntFolderId";
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private TestandtargetService service;
    @Reference
    private RetrieverService retriever;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public String getName() {
        return "saveHTMLOfferContent";
    }

    public HtmlResponse performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        String configPath = request.getParameter(PARAM_CFG);
        String path = request.getParameter(PARAM_PATH);
        String folderId = request.getParameter(PARAM_FOLDERID);
        String content = request.getParameter(PARAM_CONTENT);
        JSONWriter out = new JSONWriter((Writer)response.getWriter());
        try {
            Configuration config = null;
            if (configPath != null) {
                config = this.configurationManager.getConfiguration(configPath);
            }
            if (config == null) {
                String msg = I18n.get((HttpServletRequest)request, (String)"Configuration '{0}' not found", null, (Object[])new Object[]{configPath});
                out.object();
                out.key("error").value((Object)msg);
                out.endObject();
                return null;
            }
            Resource offerResource = request.getResourceResolver().getResource(path);
            String offerName = OfferHelper.getOfferName(path);
            String offerContent = content != null ? content : this.getOfferContent(request, offerResource);
            Calendar lastpublished = GregorianCalendar.getInstance();
            if (offerContent != null) {
                this.service.createHTMLOffer(config, offerName, folderId, offerContent);
                PageManager pageMgr = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
                Page offerPage = pageMgr.getPage(offerResource.getPath());
                Node pageContent = (Node)offerPage.getContentResource().adaptTo(Node.class);
                pageContent.setProperty(PN_FOLDERID, folderId);
                pageContent.setProperty(PN_LASTPUBLISHED, lastpublished);
                OfferHelper.setConfigurationPath(configPath, offerPage);
                ((Node)offerPage.adaptTo(Node.class)).getSession().save();
                out.object();
                out.key("success").value(true);
                out.key(PARAM_FOLDERID).value((Object)folderId);
                out.key("lastpublished").value((Object)this.sdf.format(lastpublished.getTime()));
                out.endObject();
            } else {
                out.object();
                out.key("error").value((Object)I18n.get((HttpServletRequest)request, (String)"Paragraph is empty. Create content first."));
                out.endObject();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                out.object();
                out.key("error").value((Object)e.getMessage());
                out.endObject();
            }
            catch (JSONException je) {
                log.error(je.getMessage(), (Throwable)je);
            }
        }
        return null;
    }

    private String getOfferContent(SlingHttpServletRequest request, Resource offerResource) throws Exception {
        Resource par = request.getResourceResolver().getResource(offerResource.getPath() + "/jcr:content/par");
        if (par != null) {
            String baseUri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            String uri = baseUri + offerResource.getPath() + "/jcr:content/par.html";
            OfferHtmlStorage storage = new OfferHtmlStorage();
            this.retriever.retrieve(uri, null, (RetrieverStorage)storage);
            return storage.getContent();
        }
        return null;
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }

    protected void bindService(TestandtargetService testandtargetService) {
        this.service = testandtargetService;
    }

    protected void unbindService(TestandtargetService testandtargetService) {
        if (this.service == testandtargetService) {
            this.service = null;
        }
    }

    protected void bindRetriever(RetrieverService retrieverService) {
        this.retriever = retrieverService;
    }

    protected void unbindRetriever(RetrieverService retrieverService) {
        if (this.retriever == retrieverService) {
            this.retriever = null;
        }
    }

    private class OfferHtmlStorage
    implements RetrieverStorage {
        private String content;

        private OfferHtmlStorage() {
        }

        public String getContent() {
            return this.content;
        }

        public void storeContent(String content) throws IOException, RepositoryException {
            this.content = content;
        }

        public String maybeDownloadResource(String elementName, String attributeName, String resourceUri, Attributes attributes) throws IOException, RepositoryException {
            return null;
        }
    }
}

