/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.util;

import com.day.cq.analytics.sitecatalyst.Framework;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MboxHelper {
    private static final Logger log = LoggerFactory.getLogger(MboxHelper.class);

    private MboxHelper() {
    }

    public static String getMboxName(Resource rsrc) {
        String mboxName = "";
        ValueMap resourceConfig = (ValueMap)(rsrc = MboxHelper.getStartResource(rsrc)).adaptTo(ValueMap.class);
        if (resourceConfig != null) {
            mboxName = (String)resourceConfig.get("jcr:title", (Object)"");
            if ("".equals(mboxName)) {
                mboxName = MboxHelper.getMboxId(rsrc);
            }
            mboxName = mboxName.replaceAll("\\s", "");
        }
        return mboxName;
    }

    public static String getMboxId(Resource rsrc) {
        String mboxId = "";
        if ((rsrc = MboxHelper.getStartResource(rsrc)) != null) {
            mboxId = MboxHelper.getMboxId(rsrc.getPath());
        }
        return mboxId;
    }

    public static String qualifyMboxNameOrId(String mboxNameOrId, WCMMode wcmMode) {
        if (wcmMode == WCMMode.DISABLED) {
            return mboxNameOrId;
        }
        return mboxNameOrId + "--author";
    }

    public static String getMboxId(String path) {
        return path.replaceAll("/", "-").replaceAll("-jcr:content", "").substring(1);
    }

    public static Resource searchStartElement(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (ResourceUtil.isA((Resource)resource, (String)"cq/personalization/components/mbox/start")) {
            return resource;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        ArrayList<Resource> predecessor = new ArrayList<Resource>();
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            predecessor.add(current);
        }
        Collections.reverse(predecessor);
        for (Resource current2 : predecessor) {
            if (ResourceUtil.isA((Resource)current2, (String)"cq/personalization/components/mbox/start")) {
                return current2;
            }
            if (!ResourceUtil.isA((Resource)current2, (String)"cq/personalization/components/mbox/end")) continue;
            return null;
        }
        return MboxHelper.searchStartElement(parent);
    }

    private static Resource getStartResource(Resource rsrc) {
        Resource startElement;
        if ("cq/personalization/components/mbox/end".equals(rsrc.getResourceType()) && (startElement = MboxHelper.searchStartElement(rsrc)) != null) {
            return startElement;
        }
        return rsrc;
    }

    public static String getCustomMboxJsPath(Resource resource, Page currentPage, ConfigurationManager cfgMgr) throws RepositoryException {
        boolean isValidConfig;
        Configuration configuration = null;
        HierarchyNodeInheritanceValueMap mboxProperties = new HierarchyNodeInheritanceValueMap(resource);
        String[] services = (String[])mboxProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
        if (services.length == 0) {
            mboxProperties = new HierarchyNodeInheritanceValueMap(currentPage.getContentResource());
            services = (String[])mboxProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
        }
        if (cfgMgr != null) {
            configuration = cfgMgr.getConfiguration("testandtarget", services);
        }
        boolean bl = isValidConfig = configuration != null && configuration.getInherited("clientcode", null) != null;
        if (isValidConfig) {
            Node configNode = null;
            if (configuration != null) {
                configNode = (Node)configuration.getResource().adaptTo(Node.class);
            }
            if (configNode.hasNode("./jcr:content/mbox.js")) {
                Node scriptNode = configNode.getNode("./jcr:content/mbox.js");
                return scriptNode.getPath();
            }
        }
        return null;
    }

    public static boolean isAccurateRendering(Resource resource) throws RepositoryException {
        return (Boolean)((ValueMap)resource.adaptTo(ValueMap.class)).get("accurateTargeting", (Object)false);
    }

    public static List<String> getClientContextParameterNames(Resource resource, InheritanceValueMap pageProperties, ConfigurationManager configurationManager) throws RepositoryException {
        return new ArrayList<String>(MboxHelper.getMappedClientContextParameterNames(resource, pageProperties, configurationManager).values());
    }

    public static Map<String, String> getMappedClientContextParameterNames(Resource resource, InheritanceValueMap pageProperties, ConfigurationManager configurationManager) throws RepositoryException {
        LinkedHashMap<String, String> mappedProperties = new LinkedHashMap<String, String>();
        List<Object> directMappings = Arrays.asList((Object[])((ValueMap)resource.adaptTo(ValueMap.class)).get("cq:mappings", (Object)new String[0]));
        for (String string : directMappings) {
            mappedProperties.put(string, string.replace('/', '.'));
        }
        Framework framework = MboxHelper.getFramework(pageProperties, configurationManager);
        if (framework == null) {
            return mappedProperties;
        }
        for (String scVar : framework.scVars()) {
            mappedProperties.put(framework.getMapping(scVar), scVar);
        }
        return mappedProperties;
    }

    public static Map<String, String> getStaticParameters(Resource resource) throws Exception {
        String[] staticParameters = (String[])((ValueMap)resource.adaptTo(ValueMap.class)).get("staticParams", (Object)new String[0]);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (String keyAndValue : staticParameters) {
            JSONArray array = new JSONArray(keyAndValue);
            toReturn.put(array.getString(0), array.getString(1));
        }
        return toReturn;
    }

    private static Framework getFramework(InheritanceValueMap pageProperties, ConfigurationManager configurationManager) {
        String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
        log.debug("Found has {} service configs", (Object)services.length);
        if (services.length == 0) {
            return null;
        }
        Configuration configuration = configurationManager.getConfiguration("testandtarget", services);
        if (configuration == null) {
            return null;
        }
        log.debug("Resource configured to use configuration at {}", (Object)configuration.getPath());
        return (Framework)configuration.getContentResource().adaptTo(Framework.class);
    }
}

