/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.audit.impl;

import com.day.cq.audit.AuditLog;
import com.day.cq.audit.AuditLogEntry;
import com.day.cq.audit.AuditLogEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobProcessor;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuditLog
implements AuditLog,
EventHandler,
JobProcessor {
    private static final int LOGENTRIES_PER_TRANSACTION = 1000;
    private static final String PROPERTY_CATEGORY = "cq:category";
    private static final String PROPERTY_TYPE = "cq:type";
    private static final String PROPERTY_PATH = "cq:path";
    private static final String PROPERTY_USERID = "cq:userid";
    private static final String PROPERTY_DATE = "cq:time";
    private static final String PROPERTY_PROPERTIES = "cq:properties";
    private static final String INTERMEDIATE_FOLDER_NODETYPE = "sling:Folder";
    private static final String FOLDER_NODETYPE = "sling:Folder";
    private static final String NODE_TYPE = "cq:AuditEvent";
    private static final String NAME_PROPERTY = "name";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONFIG_PROPERTY_REPO_PATH = "repository.path";
    private static final String CONFIG_PROPERTY_WORKSPACE = "workspace";
    private static final String DEFAULT_WORKSPACE = "crx.default";
    private static final String DEFAULT_REPO_PATH = "/var/audit";
    private SlingRepository repository;
    private String repositoryPath;
    private String workspaceName;
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private ClassLoader javaObjectClassLoader;
    private static final String[] IGNORE_PREFIXES = new String[]{"cq:"};

    protected void activate(ComponentContext context) throws RepositoryException {
        this.repositoryPath = OsgiUtil.toString(context.getProperties().get(CONFIG_PROPERTY_REPO_PATH), (String)DEFAULT_REPO_PATH);
        this.workspaceName = OsgiUtil.toString(context.getProperties().get(CONFIG_PROPERTY_WORKSPACE), (String)DEFAULT_WORKSPACE);
        this.createRepositoryPath();
    }

    private Session createSession() throws RepositoryException {
        return this.repository.loginAdministrative(this.workspaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepositoryPath() throws RepositoryException {
        Session session = this.createSession();
        try {
            this.createPath(session, this.repositoryPath);
        }
        finally {
            session.logout();
        }
    }

    private Node createPath(Session session, String nodePath) throws RepositoryException {
        return JcrResourceUtil.createPath((String)nodePath, (String)"sling:Folder", (String)"sling:Folder", (Session)session, (boolean)true);
    }

    public void handleEvent(Event event) {
        if (EventUtil.isLocal((Event)event)) {
            EventUtil.processJob((Event)event, (JobProcessor)this);
        }
    }

    public boolean process(Event job) {
        AuditLogEvent event = (AuditLogEvent)job.getProperty("com.day.cq.audit.event");
        if (event != null) {
            return this.internalAdd(event.getEntries());
        }
        return true;
    }

    @Override
    public void add(AuditLogEntry event) {
        this.internalAdd(Collections.singletonList(event).iterator());
    }

    @Override
    public void add(List<AuditLogEntry> entries) {
        this.internalAdd(entries.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalAdd(Iterator<AuditLogEntry> iterator) {
        try {
            Session session = this.createSession();
            try {
                int count = 0;
                while (iterator.hasNext()) {
                    while (iterator.hasNext() && count++ < 1000) {
                        AuditLogEntry entry = iterator.next();
                        Node parentNode = this.createParentNode(session, entry.getCategory(), entry.getPath());
                        this.createNode(parentNode, entry);
                    }
                    count = 0;
                    session.save();
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to create new session or add new audit log entry.", (Throwable)re);
            return false;
        }
        return true;
    }

    private Node createParentNode(Session session, String category, String originalPath) throws RepositoryException {
        String path;
        int pos = originalPath.indexOf(91);
        if (pos != -1) {
            String tmpPath = originalPath;
            while (pos != -1) {
                int posEnd = tmpPath.indexOf(93, pos);
                if (posEnd != -1) {
                    tmpPath = posEnd + 1 == tmpPath.length() ? tmpPath.substring(0, pos) : tmpPath.substring(0, pos) + tmpPath.substring(posEnd + 1);
                }
                pos = tmpPath.indexOf(91);
            }
            path = tmpPath;
        } else {
            path = originalPath;
        }
        Node existingNode = this.getParentNode(session, category, path);
        if (existingNode != null) {
            return existingNode;
        }
        Node rootNode = (Node)session.getItem(this.repositoryPath);
        String categoryNodeName = category.replace('/', '.');
        session.save();
        Node parentNode = rootNode;
        if (!parentNode.hasNode(categoryNodeName)) {
            try {
                Node categoryNode = parentNode.addNode(categoryNodeName);
                categoryNode.setProperty(NAME_PROPERTY, category);
                session.save();
            }
            catch (RepositoryException re) {
                if (!parentNode.hasNode(categoryNodeName)) {
                    throw re;
                }
                session.refresh(false);
                parentNode = session.getNodeByIdentifier(parentNode.getIdentifier());
            }
        }
        parentNode = parentNode.getNode(categoryNodeName);
        if (path.length() > 0) {
            String checkPath = path;
            if (checkPath.startsWith("/")) {
                checkPath = checkPath.substring(1);
            }
            if (checkPath.length() > 0) {
                StringTokenizer st = new StringTokenizer(checkPath, "/");
                while (st.hasMoreTokens()) {
                    String pathElement = st.nextToken();
                    if (!parentNode.hasNode(pathElement)) {
                        try {
                            parentNode.addNode(pathElement);
                            session.save();
                        }
                        catch (RepositoryException re) {
                            if (!parentNode.hasNode(pathElement)) {
                                throw re;
                            }
                            session.refresh(false);
                            parentNode = session.getNodeByIdentifier(parentNode.getIdentifier());
                        }
                    }
                    parentNode = parentNode.getNode(pathElement);
                }
            }
        }
        return parentNode;
    }

    private String getParentNodePath(String category, String path) {
        StringBuffer buffer = new StringBuffer(this.repositoryPath);
        buffer.append('/');
        buffer.append(category.replace('/', '.'));
        if (path.length() > 0 && !path.equals("/")) {
            if (!path.startsWith("/")) {
                buffer.append('/');
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    private Node getParentNode(Session session, String category, String path) throws RepositoryException {
        String nodePath = this.getParentNodePath(category, path);
        if (session.itemExists(nodePath)) {
            return (Node)session.getItem(nodePath);
        }
        return null;
    }

    private final boolean isEventNode(Node node) throws RepositoryException {
        return node.isNodeType(NODE_TYPE);
    }

    private Node createNode(Node parentNode, AuditLogEntry event) throws RepositoryException {
        Calendar date = Calendar.getInstance();
        date.setTime(event.getTime());
        String eventNodeName = UUID.randomUUID().toString();
        Node auditNode = parentNode.addNode(eventNodeName, NODE_TYPE);
        auditNode.setProperty(PROPERTY_DATE, date);
        auditNode.setProperty(PROPERTY_USERID, event.getUserId());
        auditNode.setProperty(PROPERTY_PATH, event.getPath());
        auditNode.setProperty(PROPERTY_TYPE, event.getType());
        auditNode.setProperty(PROPERTY_CATEGORY, event.getCategory());
        DefaultAuditLog.addProperties(auditNode, event.getProperties(), null, PROPERTY_PROPERTIES);
        return auditNode;
    }

    private AuditLogEntry getEvent(Node eventNode) throws RepositoryException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        ClassLoader dynamicCL = this.javaObjectClassLoader;
        if (dynamicCL != null) {
            Thread.currentThread().setContextClassLoader(dynamicCL);
        }
        try {
            AuditLogEntry event;
            Map<String, Object> properties = DefaultAuditLog.readProperties(eventNode, PROPERTY_PROPERTIES, IGNORE_PREFIXES);
            AuditLogEntry auditLogEntry = event = new AuditLogEntry(eventNode.getProperty(PROPERTY_CATEGORY).getString(), eventNode.getProperty(PROPERTY_DATE).getDate().getTime(), eventNode.getProperty(PROPERTY_USERID).getString(), eventNode.getProperty(PROPERTY_PATH).getString(), eventNode.getProperty(PROPERTY_TYPE).getString(), properties.size() == 0 ? null : properties);
            return auditLogEntry;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RepositoryException("Unable to deserialize event properties.", (Throwable)cnfe);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditLogEntry getLatestEvent(String category, String path) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        AuditLogEntry event = null;
        Session session = null;
        try {
            session = this.createSession();
            ArrayList<AuditLogEntry> events = new ArrayList<AuditLogEntry>();
            this.getLatestEvents(session, events, new String[]{category}, null, path, 1, false);
            if (events.size() > 0) {
                AuditLogEntry auditLogEntry = (AuditLogEntry)events.get(0);
                return auditLogEntry;
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to query repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditLogEntry getLatestEvent(String category, String path, String type) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        AuditLogEntry event = null;
        Session session = null;
        try {
            session = this.createSession();
            ArrayList<AuditLogEntry> events = new ArrayList<AuditLogEntry>();
            this.getLatestEvents(session, events, new String[]{category}, type, path, 1, false);
            if (events.size() > 0) {
                AuditLogEntry auditLogEntry = (AuditLogEntry)events.get(0);
                return auditLogEntry;
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to query repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        Session session = null;
        try {
            session = this.createSession();
            Node rootNode = (Node)session.getItem(this.repositoryPath);
            NodeIterator iter = rootNode.getNodes();
            while (iter.hasNext()) {
                Node current = iter.nextNode();
                if (this.isEventNode(current)) continue;
                categories.add(current.getProperty(NAME_PROPERTY).getString());
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to query repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return categories.toArray(new String[categories.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditLogEntry[] getLatestEvents(String category, String path, int max) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        Session session = null;
        try {
            session = this.createSession();
            ArrayList<AuditLogEntry> events = new ArrayList<AuditLogEntry>();
            this.getLatestEvents(session, events, new String[]{category}, null, path, max, false);
            AuditLogEntry[] auditLogEntryArray = events.toArray(new AuditLogEntry[events.size()]);
            return auditLogEntryArray;
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to query repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return new AuditLogEntry[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditLogEntry[] getLatestEventsFromTree(String[] categories, String pathPrefix, int max) {
        if (categories == null || categories.length == 0) {
            throw new IllegalArgumentException("Categories must not be null or empty.");
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException("PathPrefix must not be null.");
        }
        Session session = null;
        try {
            session = this.createSession();
            ArrayList<AuditLogEntry> events = new ArrayList<AuditLogEntry>();
            this.getLatestEvents(session, events, categories, null, pathPrefix, max, true);
            AuditLogEntry[] auditLogEntryArray = events.toArray(new AuditLogEntry[events.size()]);
            return auditLogEntryArray;
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to query repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return new AuditLogEntry[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditLogEntry[] getLatestEvents(String[] categories, String path, int max) {
        if (categories == null || categories.length == 0) {
            throw new IllegalArgumentException("Categories must not be null or empty.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        Session session = null;
        try {
            session = this.createSession();
            ArrayList<AuditLogEntry> events = new ArrayList<AuditLogEntry>();
            this.getLatestEvents(session, events, categories, null, path, max, false);
            AuditLogEntry[] auditLogEntryArray = events.toArray(new AuditLogEntry[events.size()]);
            return auditLogEntryArray;
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to query repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return new AuditLogEntry[0];
    }

    private void getLatestEvents(Session session, List<AuditLogEntry> events, String[] categories, String type, String path, int max, boolean recursive) throws RepositoryException {
        for (String category : categories) {
            Node parentNode = this.getParentNode(session, category, path);
            if (parentNode == null) continue;
            this.collectEvents(events, parentNode, type, max, recursive);
        }
    }

    private void collectEvents(List<AuditLogEntry> events, Node parentNode, String type, int max, boolean recursive) throws RepositoryException {
        NodeIterator iter = parentNode.getNodes();
        while (iter.hasNext()) {
            Node current = iter.nextNode();
            if (this.isEventNode(current)) {
                AuditLogEntry event = this.getEvent(current);
                if (type != null && !type.equals(event.getType())) continue;
                events.add(event);
                Collections.sort(events, AuditEventComparator.SINGLETON);
                while (max >= 0 && events.size() > max) {
                    events.remove(max);
                }
                continue;
            }
            if (!recursive) continue;
            this.collectEvents(events, current, type, max, recursive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(String srcPath, String destPath) {
        if (srcPath == null) {
            throw new IllegalArgumentException("Src Path must not be null.");
        }
        if (destPath == null) {
            throw new IllegalArgumentException("Dest Path must not be null.");
        }
        int pos = destPath.lastIndexOf(47);
        String destParentPath = pos == 0 ? "" : destPath.substring(0, pos);
        String name = destPath.substring(pos + 1);
        Session session = null;
        try {
            String[] categories;
            session = this.createSession();
            for (String category : categories = this.getCategories()) {
                Node srcNode = this.getParentNode(session, category, srcPath);
                if (srcNode == null) continue;
                String destNodePath = this.getParentNodePath(category, destParentPath);
                Node parentDestNode = this.createPath(session, destNodePath);
                if (!parentDestNode.hasNode(name)) {
                    session.move(srcNode.getPath(), destNodePath + "/" + name);
                    continue;
                }
                Node destNode = parentDestNode.getNode(name);
                NodeIterator ni = srcNode.getNodes();
                while (ni.hasNext()) {
                    Node current = ni.nextNode();
                    session.move(current.getPath(), destNode.getPath() + "/" + current.getName());
                }
            }
            session.save();
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to move audit log n repository.", (Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dclm) {
        this.dynamicClassLoaderManager = dclm;
        this.javaObjectClassLoader = dclm.getDynamicClassLoader();
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dclm) {
        if (this.dynamicClassLoaderManager == dclm) {
            this.dynamicClassLoaderManager = null;
            this.javaObjectClassLoader = null;
        }
    }

    private static void addProperties(Node node, Map<String, Object> properties, String[] ignoreProps, String binPropertyName) throws RepositoryException {
        if (properties != null) {
            List<String> ignorePropList = ignoreProps == null ? null : Arrays.asList(ignoreProps);
            ArrayList<String> propsAsBlob = new ArrayList<String>();
            for (Map.Entry<String, Object> current : properties.entrySet()) {
                if (ignorePropList != null && ignorePropList.contains(current.getKey()) || current.getValue() == null || DefaultAuditLog.setProperty(current.getKey(), current.getValue(), node)) continue;
                propsAsBlob.add(current.getKey());
            }
            if (propsAsBlob.size() > 0) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeInt(propsAsBlob.size());
                    for (String propName : propsAsBlob) {
                        oos.writeObject(propName);
                        try {
                            oos.writeObject(properties.get(propName));
                        }
                        catch (IOException ioe) {
                            throw new RepositoryException("Unable to serialize property " + propName, (Throwable)ioe);
                        }
                    }
                    oos.close();
                    node.setProperty(binPropertyName, node.getSession().getValueFactory().createBinary((InputStream)new ByteArrayInputStream(baos.toByteArray())));
                }
                catch (IOException ioe) {
                    throw new RepositoryException("Unable to serialize properties " + properties, (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> readProperties(Node node, String binPropertyName, String[] ignorePrefixes) throws RepositoryException, ClassNotFoundException {
        Object value;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (node.hasProperty(binPropertyName)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(node.getProperty(binPropertyName).getBinary().getStream(), Thread.currentThread().getContextClassLoader());
                try {
                    int length = ois.readInt();
                    for (int i = 0; i < length; ++i) {
                        String key = (String)ois.readObject();
                        value = ois.readObject();
                        properties.put(key, value);
                    }
                }
                finally {
                    ois.close();
                }
            }
            catch (InvalidClassException ice) {
                throw new ClassNotFoundException("Found invalid class.", ice);
            }
            catch (IOException ioe) {
                throw new RepositoryException("Unable to deserialize event properties.", (Throwable)ioe);
            }
        }
        PropertyIterator pI = node.getProperties();
        while (pI.hasNext()) {
            Property p = pI.nextProperty();
            boolean ignore = p.getName().startsWith("jcr:");
            if (!ignore && ignorePrefixes != null) {
                for (int index = 0; !ignore && index < ignorePrefixes.length; ++index) {
                    ignore = p.getName().startsWith(ignorePrefixes[index]);
                }
            }
            if (ignore) continue;
            String name = ISO9075.decode((String)p.getName());
            if (p.getDefinition().isMultiple()) {
                Value[] values = p.getValues();
                if (values.length <= 0) continue;
                Object firstObject = DefaultAuditLog.getPropertyValue(values[0]);
                Object[] array = firstObject instanceof Boolean ? new Boolean[values.length] : (firstObject instanceof Calendar ? new Calendar[values.length] : (firstObject instanceof Double ? new Double[values.length] : (firstObject instanceof Long ? new Long[values.length] : new String[values.length])));
                array[0] = firstObject;
                for (int index = 1; index < values.length; ++index) {
                    array[index] = DefaultAuditLog.getPropertyValue(values[index]);
                }
                properties.put(name, array);
                continue;
            }
            value = p.getValue();
            Object o = DefaultAuditLog.getPropertyValue((Value)value);
            properties.put(name, o);
        }
        return properties;
    }

    private static boolean setProperty(String name, Object value, Node node) throws RepositoryException {
        String propName = DefaultAuditLog.getNodePropertyName(name);
        if (propName == null) {
            return false;
        }
        ValueFactory fac = node.getSession().getValueFactory();
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            Value[] values = new Value[array.length];
            int index = 0;
            for (Object v : array) {
                values[index] = DefaultAuditLog.getNodePropertyValue(fac, v);
                if (values[index] == null) {
                    return false;
                }
                if (index > 0 && !values[index - 1].getClass().equals(values[index].getClass())) {
                    return false;
                }
                ++index;
            }
            node.setProperty(propName, values);
            return true;
        }
        Value val = DefaultAuditLog.getNodePropertyValue(fac, value);
        if (val != null) {
            node.setProperty(propName, val);
            return true;
        }
        return false;
    }

    private static String getNodePropertyName(String name) {
        if (name.indexOf(58) != -1) {
            return null;
        }
        return ISO9075.encode((String)name);
    }

    private static Value getNodePropertyValue(ValueFactory valueFactory, Object eventValue) {
        Object val = eventValue instanceof Calendar ? valueFactory.createValue((Calendar)eventValue) : (eventValue instanceof Long ? valueFactory.createValue(((Long)eventValue).longValue()) : (eventValue instanceof Double ? valueFactory.createValue(((Double)eventValue).doubleValue()) : (eventValue instanceof Boolean ? valueFactory.createValue(((Boolean)eventValue).booleanValue()) : (eventValue instanceof String ? valueFactory.createValue((String)eventValue) : null))));
        return val;
    }

    private static Object getPropertyValue(Value value) throws RepositoryException {
        Object o;
        switch (value.getType()) {
            case 6: {
                o = value.getBoolean();
                break;
            }
            case 5: {
                o = value.getDate();
                break;
            }
            case 4: {
                o = value.getDouble();
                break;
            }
            case 3: {
                o = value.getLong();
                break;
            }
            case 1: {
                o = value.getString();
                break;
            }
            default: {
                o = value.getString();
            }
        }
        return o;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectInputStream
    extends java.io.ObjectInputStream {
        private ClassLoader classloader;

        public ObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return Class.forName(classDesc.getName(), true, this.classloader);
            }
            return super.resolveClass(classDesc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AuditEventComparator
    implements Comparator<AuditLogEntry> {
        protected static final AuditEventComparator SINGLETON = new AuditEventComparator();

        private AuditEventComparator() {
        }

        @Override
        public int compare(AuditLogEntry o1, AuditLogEntry o2) {
            return o1.getTime().compareTo(o2.getTime()) * -1;
        }
    }
}

