/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.Graph;
import com.day.cq.graphics.chart.Axis;
import com.day.cq.graphics.chart.Chart;
import com.day.cq.graphics.chart.Data;
import com.day.cq.graphics.chart.Metrics;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class BarChart
extends Chart {
    public static final int BARS_TILE = 0;
    public static final int BARS_CASCADE = 1;
    public static final int BARS_HORIZONTAL = 2;
    public static final int BARS_CANDLE = 3;
    int style = 0;
    int barwidth = 0;
    int barspacing = 0;
    int numlines = 0;

    public static String getName() {
        return "bar";
    }

    public Layer draw(Graph graph, boolean doDraw) {
        int numtitles = 0;
        Axis yAxis = graph.getYAxis();
        Axis xAxis = graph.getXAxis();
        if ((yAxis.titlepos & 1) != 0) {
            ++numtitles;
        }
        if ((yAxis.titlepos & 2) != 0) {
            ++numtitles;
        }
        if (this.style == 2) {
            yAxis.setType(118);
            if (yAxis.height == 0) {
                yAxis.setRangescale(0.0);
                yAxis.height = yAxis.tickdistance * (graph.getData().numrows + numtitles);
            } else if (yAxis.tickdistance == 0) {
                yAxis.setRangescale(0.0);
                yAxis.tickdistance = yAxis.height / (graph.getData().numrows + numtitles);
            } else {
                yAxis.setRangescale(yAxis.tickdistance);
            }
            if ((yAxis.titlepos & 1) != 0) {
                yAxis.setRangemin(-1.0);
                yAxis.setRangeoffset(1.0);
            } else {
                yAxis.setRangemin(0.0);
                yAxis.setRangeoffset(0.0);
            }
            yAxis.numticks = graph.getData().numrows;
            yAxis.setRangemax(yAxis.getRangemin() + (double)numtitles + (double)graph.getData().numrows - 1.0);
            yAxis.setRangestep(1.0);
            yAxis.setLabelformat("%s");
        } else {
            yAxis.setType(121);
            this.getBarMetrics(graph, graph.getMetrics(), yAxis);
            yAxis.height = graph.getMetrics().height + 1;
            yAxis.numticks = graph.getMetrics().numlines;
            if (yAxis.labelalign == 0) {
                yAxis.height += yAxis.tickdistance;
                ++yAxis.numticks;
            }
            yAxis.setRangemin(graph.getMetrics().bottomvalue);
            yAxis.setRangemax(graph.getMetrics().topvalue);
            yAxis.setRangestep(graph.getMetrics().distance);
            if (yAxis.getRangescale() == 0.0) {
                yAxis.setRangescale((double)graph.getMetrics().height / (yAxis.getRangemax() - yAxis.getRangemin()));
                yAxis.numticks = (int)((yAxis.getRangemax() - yAxis.getRangemin()) / yAxis.getRangestep());
            }
            yAxis.setRangeoffset(-yAxis.getRangemin());
            yAxis.setLabelformat("%." + graph.getMetrics().coma + "f");
        }
        if (xAxis.rangetype == 4 || xAxis.rangetype == 5) {
            int numticks = graph.getData().numcols;
            if (xAxis.width == 0) {
                xAxis.width = xAxis.tickdistance - numticks;
                xAxis.setRangescale(0.0);
            } else if (xAxis.tickdistance == 0) {
                xAxis.tickdistance = xAxis.width / numticks;
                xAxis.setRangescale(0.0);
            } else {
                xAxis.setRangescale(xAxis.tickdistance);
            }
            xAxis.setType(117);
            xAxis.setRangemin(0.0);
            xAxis.setRangemax(numticks - 1);
            xAxis.setRangestep(1.0);
            xAxis.setRangeoffset(0.5);
            xAxis.setLabelformat("%s");
        } else {
            xAxis.setType(120);
            this.getBarMetrics(graph, graph.getMetrics(), xAxis);
            xAxis.numticks = graph.getMetrics().numlines - 1;
            if (xAxis.width == 0) {
                xAxis.width = graph.getMetrics().height;
                xAxis.setRangescale(graph.getMetrics().scaley);
            } else if (xAxis.tickdistance == 0) {
                xAxis.tickdistance = xAxis.width / xAxis.numticks;
                xAxis.setRangescale((double)xAxis.width / (graph.getMetrics().topvalue - graph.getMetrics().minvalue));
            } else {
                xAxis.setRangescale(graph.getMetrics().scaley);
            }
            xAxis.setRangemin(graph.getMetrics().minvalue);
            xAxis.setRangemax(graph.getMetrics().maxvalue);
            xAxis.setRangestep(graph.getMetrics().distance);
            xAxis.setRangeoffset(0.0);
            xAxis.setLabelformat("%." + graph.getMetrics().coma + "f");
        }
        Layer[] axisLayers = new Layer[]{graph.getYAxis().draw(graph, doDraw), graph.getXAxis().draw(graph, doDraw)};
        Layer dataLayer = this.drawBars(graph, doDraw);
        dataLayer.merge(axisLayers);
        return doDraw ? dataLayer : null;
    }

    public void setStyle(int style) {
        if (this.style == 0) {
            this.style = style;
        }
    }

    public void setBarwidth(int barwidth) {
        if (this.barwidth == 0) {
            this.barwidth = barwidth;
        }
    }

    public void setBarspacing(int barspacing) {
        if (this.barspacing == 0) {
            this.barspacing = barspacing;
        }
    }

    public void setNumlines(int numlines) {
        if (this.numlines == 0) {
            this.numlines = numlines;
        }
    }

    private void getBarMetrics(Graph graph, Metrics mx, Axis ax) {
        int coma;
        double power;
        double delta;
        int j;
        Data data = graph.getData();
        int approx = this.numlines;
        double maxValue = 0.0;
        double minValue = 0.0;
        double topValue = 0.0;
        double botValue = 0.0;
        if (this.style == 0) {
            for (j = 0; j < data.numcols; ++j) {
                double rest = 0.0;
                for (int i = 0; i < data.numrows; ++i) {
                    rest += data.datarows[i].samples[j];
                }
                if (!(rest > maxValue)) continue;
                maxValue = rest;
            }
        } else {
            if (this.style == 3) {
                minValue = Double.MAX_VALUE;
            }
            for (j = 0; j < data.numcols; ++j) {
                for (int i = 0; i < data.numrows; ++i) {
                    double rest = data.datarows[i].samples[j];
                    if (rest < minValue) {
                        minValue = rest;
                    }
                    if (!(rest > maxValue)) continue;
                    maxValue = rest;
                }
            }
        }
        if ((delta = (maxValue *= ax.inflate) - minValue) == 0.0) {
            delta = 1.0;
        }
        if ((power = Math.log(delta) / Math.log(10.0)) == Math.floor(power)) {
            power -= 1.0;
        }
        power = Math.floor(power);
        double distance = 0.0;
        double ac = 0.0;
        int first = 0;
        double[] factors = new double[]{0.1, 0.2, 0.25, 0.3, 0.5, 0.6, 1.0};
        do {
            for (int i = first; i < factors.length; ++i) {
                distance = Math.pow(10.0, power) * (factors[i] + ac);
                topValue = Math.ceil(maxValue / distance) * distance;
                if (topValue == maxValue) {
                    topValue += distance;
                }
                botValue = Math.floor(minValue / distance) * distance;
                this.numlines = (int)((topValue - botValue) / distance);
                if (this.numlines <= approx) break;
            }
            ac += 1.0;
            first = 1;
        } while (this.numlines > approx);
        ax.tickdistance = graph.getExtent().height / this.numlines;
        int height = ax.tickdistance * this.numlines;
        double scale = (double)height / (topValue - botValue);
        double rest = distance - Math.rint(distance);
        for (coma = 0; rest > 1.0E-5 && rest < 1.0 && coma < 4; ++coma) {
            rest = rest * 10.0 - Math.rint(rest * 10.0);
        }
        mx.height = height;
        mx.coma = coma;
        mx.topvalue = topValue;
        mx.bottomvalue = botValue;
        mx.distance = distance;
        mx.scaley = scale;
        mx.shifty = -((int)(topValue * scale));
        mx.numlines = this.numlines;
        mx.maxvalue = maxValue;
        mx.minvalue = minValue;
    }

    private Layer drawBars(Graph graph, boolean doDraw) {
        double d;
        int rt;
        if (!doDraw) {
            return null;
        }
        Axis xAxis = graph.getXAxis();
        Axis yAxis = graph.getYAxis();
        int w = xAxis.width;
        int h = yAxis.height;
        if ((yAxis.titlepos & 2) != 0) {
            h = (int)((double)h - yAxis.getRangescale());
        }
        Layer l = graph.createLayer(true, w, h);
        if ((yAxis.titlepos & 1) != 0) {
            double scale = xAxis.getRangescale();
            int ypos = xAxis.subtickto > xAxis.tickto ? xAxis.subtickto : xAxis.tickto;
            double pos = xAxis.getRangemin();
            int num = 0;
            while (num <= xAxis.numticks) {
                int x = (int)((pos + xAxis.getRangeoffset()) * scale);
                if (xAxis.labelfont != null) {
                    int rl = x + xAxis.labeldx;
                    rt = ypos - xAxis.tickfrom - xAxis.labeldy;
                    String tmp = String.format(xAxis.getLabelformat(), String.valueOf(pos));
                    int flags = 0;
                    if (xAxis.labelalign == 32) {
                        flags = 16;
                        rl -= xAxis.labelwidth / 2;
                    }
                    xAxis.labelfont.drawText(l, rl, rt, xAxis.labelwidth, 0, tmp, (Paint)xAxis.labelcolor, null, flags, (double)xAxis.labelcs, 0);
                }
                ++num;
                pos += xAxis.getRangestep();
            }
        }
        graph.getGrid().draw(l, doDraw);
        if (xAxis.getType() == 117) {
            int bw = this.barwidth;
            int col = (int)xAxis.getRangemin();
            while ((double)col <= xAxis.getRangemax()) {
                if (this.style == 0) {
                    double realtop = 0.0;
                    int rt2 = h - 1;
                    int rb = 0;
                    int rl = (int)(((double)col + xAxis.getRangeoffset()) * xAxis.getRangescale() - (double)(bw / 2));
                    int rr = rl + bw;
                    for (int row = 0; row < graph.getData().numrows; ++row) {
                        rb = rt2;
                        rt2 = h - 1 - (int)((double)Math.round(realtop += graph.getData().datarows[row].samples[col]) * yAxis.getRangescale());
                        l.setPaint((Paint)graph.getData().datarows[row].color);
                        l.fillRect((Rectangle2D)new Rectangle(rl, rt2, rr - rl, rb - rt2));
                    }
                } else if (this.style == 3) {
                    int bsp = this.barspacing;
                    for (int row = 0; row < graph.getData().numrows; row += 2) {
                        int rr;
                        int rl;
                        Color color;
                        int rt3;
                        int rb;
                        double d1;
                        double d0 = graph.getData().datarows[row].samples[col] + yAxis.getRangeoffset();
                        if (d0 > (d1 = graph.getData().datarows[row + 1].samples[col] + yAxis.getRangeoffset())) {
                            rb = h - 1 - (int)(d1 * yAxis.getRangescale());
                            rt3 = h - 1 - (int)(d0 * yAxis.getRangescale());
                            color = graph.getData().datarows[row + 1].color;
                        } else {
                            rb = h - 1 - (int)(d0 * yAxis.getRangescale());
                            rt3 = h - 1 - (int)(d1 * yAxis.getRangescale());
                            color = graph.getData().datarows[row].color;
                        }
                        if (row % 4 != 0) {
                            rl = (int)(((double)col + xAxis.getRangeoffset()) * xAxis.getRangescale() - (double)(bw / 2));
                            rr = rl + bw + 1;
                        } else {
                            rl = (int)(((double)col + xAxis.getRangeoffset()) * xAxis.getRangescale() - (double)(bsp / 2));
                            rr = rl + bsp + 1;
                        }
                        l.setPaint((Paint)color);
                        l.fillRect((Rectangle2D)new Rectangle(rl, rt3, rr - rl, rb - rt3));
                    }
                } else {
                    int zeroline = (int)((double)(h - 1) - yAxis.getRangeoffset() * yAxis.getRangescale());
                    int bsp = this.barspacing;
                    int rr = (int)(((double)col + xAxis.getRangeoffset()) * xAxis.getRangescale() - (double)((bw * graph.getData().numrows + bsp * (graph.getData().numrows - 1)) / 2)) - bsp;
                    for (int row = 0; row < graph.getData().numrows; ++row) {
                        int rb;
                        d = graph.getData().datarows[row].samples[col];
                        int rl = rr + bsp;
                        rr = rl + bw;
                        if (d >= 0.0) {
                            rb = zeroline;
                            rt = zeroline - (int)(d * yAxis.getRangescale());
                        } else {
                            rt = zeroline;
                            rb = zeroline - (int)(d * yAxis.getRangescale());
                        }
                        l.setPaint((Paint)graph.getData().datarows[row].color);
                        l.fillRect((Rectangle2D)new Rectangle(rl, rt, rr - rl, rb - rt));
                    }
                }
                col = (int)((double)col + xAxis.getRangestep());
            }
            l.setY(-h);
        } else if (this.style == 2) {
            int bw = this.barwidth;
            for (int col = 0; col < graph.getData().numrows; ++col) {
                int y = (int)((double)yAxis.tickpos[col] + yAxis.getRangescale() / 2.0);
                int rt4 = y - bw / 2;
                int rb = y + bw / 2;
                int rl = 0;
                d = graph.getData().datarows[col].samples[0];
                int rr = (int)(d * xAxis.getRangescale());
                l.setPaint((Paint)graph.getData().datarows[0].color);
                l.fillRect((Rectangle2D)new Rectangle(rl, rt4, rr - rl, rb - rt4));
            }
            l.setX(1);
            l.setY(-h - 1);
        }
        return l;
    }
}

