/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.chart.DataRow;

public class Data {
    String[] labels;
    double[][] samples;
    int numrows;
    int numcols;
    DataRow[] datarows;
    int[][] xcoords;
    int[][] ycoords;

    public Data(int numrows, int numcols) {
        this.numrows = numrows;
        this.numcols = numcols;
        this.datarows = new DataRow[numrows];
        this.xcoords = new int[numrows][numcols];
        this.ycoords = new int[numrows][numcols];
    }

    public void setSamples(double[][] samples) {
        if (samples == null || samples.length == 0 || samples[0] == null || samples[0].length == 0) {
            throw new IllegalArgumentException("Samples must not be empty");
        }
        this.samples = samples;
        for (int i = 0; i < this.numrows && i < samples.length; ++i) {
            this.datarows[i] = new DataRow(i, samples[i]);
        }
    }

    public void setLabels(String[] labels) {
        if (labels == null) {
            labels = new String[]{};
        }
        this.labels = labels;
    }

    public void setLegends(String[] legends) {
        if (legends == null) {
            legends = new String[]{};
        }
        for (int i = 0; i < this.numrows && i < legends.length; ++i) {
            this.datarows[i].label = legends[i];
        }
    }

    public int getNumrows() {
        return this.numrows;
    }

    public int getNumcols() {
        return this.numcols;
    }

    public DataRow getDataRow(int i) {
        if (i >= 0 && i < this.datarows.length) {
            return this.datarows[i];
        }
        return null;
    }

    public int getXCoord(int row, int col) {
        return this.xcoords[row][col];
    }

    public int getYCoord(int row, int col) {
        return this.ycoords[row][col];
    }
}

