/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.Graph;
import com.day.cq.graphics.chart.Axis;
import com.day.cq.graphics.chart.Chart;
import com.day.cq.graphics.chart.Data;
import com.day.cq.graphics.chart.Metrics;
import com.day.image.Layer;
import com.day.image.LineStyle;
import java.awt.Paint;

public class LineChart
extends Chart {
    int style;
    int numlines;
    float linewidth;

    public static String getName() {
        return "line";
    }

    public Layer draw(Graph graph, boolean doDraw) {
        Metrics metrics = graph.getMetrics();
        this.getLineMetrics(graph, metrics);
        Axis yAxis = graph.getYAxis();
        yAxis.setType(121);
        yAxis.height = metrics.height + 1;
        yAxis.numticks = metrics.numlines;
        yAxis.setRangemin(metrics.bottomvalue);
        yAxis.setRangemax(metrics.topvalue);
        yAxis.setRangestep(metrics.distance);
        yAxis.setRangescale((double)metrics.height / (yAxis.getRangemax() - yAxis.getRangemin()));
        yAxis.numticks = (int)((yAxis.getRangemax() - yAxis.getRangemin()) / yAxis.getRangestep());
        yAxis.setRangeoffset(-yAxis.getRangemin());
        yAxis.setLabelformat("%." + metrics.coma + "f");
        Axis xAxis = graph.getXAxis();
        xAxis.setType(117);
        xAxis.setRangemin(0.0);
        xAxis.setRangemax(graph.getData().numcols - 1);
        xAxis.setRangestep(1.0);
        xAxis.setRangeoffset(0.0);
        xAxis.setLabelformat(xAxis.labeltype == 0 ? "%s" : "%Y");
        if ((graph.getFlags() & 1) != 0) {
            xAxis.setRangescale((double)(xAxis.width - xAxis.labelwidth) / (double)(graph.getData().numcols - 1));
        } else {
            xAxis.setRangescale((double)(xAxis.width - xAxis.labelwidth) / (double)graph.getData().numcols);
        }
        Layer[] axisLayers = new Layer[]{graph.getYAxis().draw(graph, doDraw), graph.getXAxis().draw(graph, doDraw)};
        Layer dataLayer = this.drawLines(graph, doDraw);
        dataLayer.merge(axisLayers);
        return doDraw ? dataLayer : null;
    }

    public void setStyle(int style) {
        if (this.style == 0) {
            this.style = style;
        }
    }

    public void setNumlines(int numlines) {
        if (this.numlines == 0) {
            this.numlines = numlines;
        }
    }

    public void setLinewidth(float linewidth) {
        if (this.linewidth == 0.0f) {
            this.linewidth = linewidth;
        }
    }

    private void getLineMetrics(Graph graph, Metrics mx) {
        int coma;
        double rest;
        int i;
        Data data = graph.getData();
        double maxValue = -1.7976931348623157E308;
        double minValue = Double.MAX_VALUE;
        double power = 0.0;
        double distance = 0.0;
        double topValue = 0.0;
        double botValue = 0.0;
        int numlines = 0;
        int approx = this.numlines;
        for (int j = 0; j < data.numcols; ++j) {
            for (i = 0; i < data.numrows; ++i) {
                rest = data.datarows[i].samples[j];
                if (rest > maxValue) {
                    maxValue = rest;
                }
                if (!(rest < minValue)) continue;
                minValue = rest;
            }
        }
        double delta = maxValue - minValue;
        if (delta == 0.0) {
            distance = maxValue;
            topValue = minValue + distance;
            botValue = 0.0;
            numlines = 3;
        } else {
            power = Math.log(delta) / Math.log(10.0);
            if (power == Math.floor(power)) {
                power -= 1.0;
            }
            power = Math.floor(power);
            double[] factors = new double[]{0.1, 0.2, 0.25, 0.3, 0.5, 0.6, 1.0};
            for (i = 0; i < factors.length; ++i) {
                distance = Math.pow(10.0, power) * factors[i];
                topValue = Math.ceil(maxValue / distance) * distance;
                if (topValue == maxValue) {
                    topValue += distance;
                }
                if ((numlines = (int)((topValue - (botValue = Math.floor(minValue / distance) * distance)) / distance)) <= approx) break;
            }
        }
        graph.getYAxis().tickdistance = graph.getExtent().height / numlines;
        int height = graph.getYAxis().tickdistance * numlines;
        rest = distance - Math.rint(distance);
        for (coma = 0; rest > 0.0 && rest < 1.0 && coma < 4; ++coma) {
            rest = rest * 10.0 - Math.rint(rest * 10.0);
        }
        double width = graph.getXAxis().width;
        mx.scalex = width / (double)(data.numcols - 1);
        mx.height = height;
        mx.coma = coma;
        mx.topvalue = topValue;
        mx.bottomvalue = botValue;
        mx.distance = distance;
        mx.scaley = (double)height / (topValue - botValue);
        mx.shifty = -((int)(topValue * mx.scaley));
        mx.numlines = numlines;
        mx.maxvalue = maxValue;
    }

    private Layer drawLines(Graph graph, boolean doDraw) {
        if (!doDraw) {
            return null;
        }
        Axis xAxis = graph.getXAxis();
        Axis yAxis = graph.getYAxis();
        int w = xAxis.width;
        int h = yAxis.height;
        int hx = xAxis.height;
        Layer l = graph.createLayer(true, w, h + hx);
        graph.getGrid().draw(l, doDraw);
        l.setY(-h);
        l.setX(1);
        for (int row = 0; row < graph.getData().numrows; ++row) {
            int x2 = (int)((xAxis.getRangemin() + xAxis.getRangeoffset()) * xAxis.getRangescale());
            int y2 = h - 1 - (int)(yAxis.getRangescale() * (yAxis.getRangeoffset() + graph.getData().datarows[row].samples[0]));
            int col = (int)xAxis.getRangemin();
            graph.getData().xcoords[row][col] = x2;
            graph.getData().ycoords[row][col] = y2;
            l.setLineStyle(new LineStyle((Paint)graph.getData().datarows[row].color, -1.0f, -1.0f, this.linewidth));
            ++col;
            while ((double)col <= xAxis.getRangemax()) {
                int x1 = x2;
                int y1 = y2;
                x2 = (int)(((double)col + xAxis.getRangeoffset()) * xAxis.getRangescale());
                y2 = h - 1 - (int)(yAxis.getRangescale() * (yAxis.getRangeoffset() + graph.getData().datarows[row].samples[col]));
                graph.getData().xcoords[row][col] = x2;
                graph.getData().ycoords[row][col] = y2;
                l.drawLine((float)x1, (float)y1, (float)x2, (float)y2);
                ++col;
            }
        }
        return l;
    }
}

