/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.Doctype;
import com.day.cq.commons.DownloadResource;
import com.day.cq.commons.ImageHelper;
import com.day.image.Layer;
import com.day.text.Text;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageResource
extends DownloadResource {
    public static final String PN_HTML_WIDTH = "htmlWidth";
    public static final String PN_HTML_HEIGHT = "htmlHeight";
    public static final String PN_WIDTH = "width";
    public static final String PN_HEIGHT = "height";
    public static final String PN_MIN_WIDTH = "minWidth";
    public static final String PN_MIN_HEIGHT = "minHeight";
    public static final String PN_MAX_WIDTH = "maxWidth";
    public static final String PN_MAX_HEIGHT = "maxHeight";
    public static final String PN_ALT = "alt";
    public static final String PN_IMAGE_CROP = "imageCrop";
    public static final String PN_IMAGE_ROTATE = "imageRotate";
    public static final String PN_LINK_URL = "linkURL";
    private Doctype doctype = Doctype.HTML_401_STRICT;
    private String extFromType;

    public ImageResource(Resource resource) {
        super(resource);
        super.setExtension(".png");
        try {
            String suffix = "";
            if (this.node != null) {
                long lastMod = 0L;
                if (this.node.hasProperty("jcr:lastModified")) {
                    lastMod = this.node.getProperty("jcr:lastModified").getLong();
                } else if (this.node.hasProperty("jcr:created")) {
                    lastMod = this.node.getProperty("jcr:created").getLong();
                }
                long fileLastMod = 0L;
                if (this.node.hasNode("file") && this.getFileReference().length() == 0) {
                    if (this.node.getNode("file").hasProperty("jcr:lastModified")) {
                        fileLastMod = this.node.getNode("file").getProperty("jcr:lastModified").getLong();
                    } else if (this.node.getNode("file").hasProperty("jcr:created")) {
                        fileLastMod = this.node.getNode("file").getProperty("jcr:created").getLong();
                    }
                }
                if (fileLastMod > lastMod) {
                    lastMod = fileLastMod;
                }
                if (lastMod == 0L) {
                    lastMod = System.currentTimeMillis();
                }
                suffix = suffix + lastMod;
                suffix = suffix + this.getExtension();
            }
            this.setSuffix(suffix);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public ImageResource(Resource resource, String imageName) {
        this(ImageResource.getRelativeResource(resource, imageName));
    }

    protected static Resource getRelativeResource(Resource resource, String relPath) {
        if (relPath == null) {
            return resource;
        }
        Resource res = resource.getResourceResolver().getResource(resource, relPath);
        if (res == null) {
            res = new NonExistingResource(resource.getResourceResolver(), resource.getPath() + "/" + relPath);
        }
        return res;
    }

    public String getAlt() {
        String alt = this.get(this.getItemName(PN_ALT));
        if (alt.length() == 0) {
            alt = this.getTitle();
        }
        return alt.length() == 0 ? this.getFileNodePath() : alt;
    }

    public void setAlt(String alt) {
        this.set(PN_ALT, alt);
    }

    public String getSrc() {
        return this.getHref();
    }

    @Override
    public String getExtension() {
        if (this.extFromType == null) {
            try {
                this.extFromType = ImageHelper.getExtensionFromType(this.getMimeType());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (this.extFromType == null) {
                this.extFromType = super.getExtension();
            } else if (!this.extFromType.startsWith(".")) {
                this.extFromType = "." + this.extFromType;
            }
        }
        return this.extFromType;
    }

    @Override
    public void setExtension(String extension) {
        this.extFromType = extension;
        super.setExtension(extension);
    }

    public void setSrc(String src) {
        super.setHref(src);
    }

    public Doctype getDoctype() {
        return this.doctype;
    }

    public void setDoctype(Doctype doctype) {
        if (doctype != null) {
            this.doctype = doctype;
        }
    }

    @Override
    public void draw(Writer w) throws IOException {
        if (this.canDraw()) {
            this.doDraw(new PrintWriter(w));
        }
    }

    protected void doDraw(PrintWriter out) {
        Map<String, String> attributes = this.getImageTagAttributes();
        String linkURL = this.get(PN_LINK_URL);
        if (linkURL.length() > 0) {
            out.printf("<a href=\"%s\">", this.completeHREF(linkURL));
        }
        out.print("<img ");
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            out.printf("%s=\"%s\" ", StringEscapeUtils.escapeHtml((String)e.getKey().toString()), StringEscapeUtils.escapeHtml((String)e.getValue().toString()));
        }
        if (this.doctype.isXHTML()) {
            out.print("/>");
        } else {
            out.print(">");
        }
        if (linkURL.length() > 0) {
            out.print("</a>");
        }
    }

    protected boolean canDraw() {
        return this.hasContent();
    }

    protected Map<String, String> getImageTagAttributes() {
        String src;
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this.get(this.getItemName(PN_HTML_WIDTH)).length() > 0) {
            attributes.put(PN_WIDTH, this.get(this.getItemName(PN_HTML_WIDTH)));
        }
        if (this.get(this.getItemName(PN_HTML_HEIGHT)).length() > 0) {
            attributes.put(PN_HEIGHT, this.get(this.getItemName(PN_HTML_HEIGHT)));
        }
        if ((src = this.getSrc()) != null) {
            attributes.put("src", Text.escape((String)src, (char)'%', (boolean)true));
        }
        attributes.put(PN_ALT, this.getAlt());
        attributes.put("title", this.getTitle());
        if (this.attrs != null) {
            attributes.putAll(this.attrs);
        }
        return attributes;
    }

    private String completeHREF(String href) {
        if (href != null && href.length() > 0 && (href.charAt(0) == '/' || href.charAt(0) == '#')) {
            int anchorPos = href.indexOf("#");
            if (anchorPos == 0) {
                return href;
            }
            String anchor = "";
            if (anchorPos > 0) {
                anchor = href.substring(anchorPos, href.length());
                href = href.substring(0, anchorPos);
            }
            int extSepPos = href.lastIndexOf(".");
            int slashPos = href.lastIndexOf("/");
            if (extSepPos <= 0 || extSepPos < slashPos) {
                href = Text.escape((String)href, (char)'%', (boolean)true) + ".html" + anchor;
            }
        }
        return href;
    }

    public Rectangle getCropRect() {
        String cropData = this.get(this.getItemName(PN_IMAGE_CROP));
        if (cropData.length() > 0) {
            return ImageHelper.getCropRect(cropData, this.getPath());
        }
        return null;
    }

    public int getRotation() {
        String rotation = this.get(this.getItemName(PN_IMAGE_ROTATE));
        if (rotation.length() > 0) {
            try {
                return Integer.parseInt(rotation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public Layer resize(Layer layer) {
        Dimension d = new Dimension(this.get(this.getItemName(PN_WIDTH), 0), this.get(this.getItemName(PN_HEIGHT), 0));
        Dimension min = new Dimension(this.get(this.getItemName(PN_MIN_WIDTH), 0), this.get(this.getItemName(PN_MIN_HEIGHT), 0));
        Dimension max = new Dimension(this.get(this.getItemName(PN_MAX_WIDTH), 0), this.get(this.getItemName(PN_MAX_HEIGHT), 0));
        return ImageHelper.resize(layer, d, min, max);
    }

    public Layer crop(Layer layer) {
        Rectangle rect = this.getCropRect();
        if (rect != null) {
            layer.crop((Rectangle2D)rect);
            return layer;
        }
        return null;
    }

    public Layer rotate(Layer layer) {
        int rotation = this.getRotation();
        if (rotation != 0) {
            layer.rotate((double)rotation);
            return layer;
        }
        return null;
    }

    public Layer getLayer(boolean cropped, boolean resized, boolean rotated) throws IOException, RepositoryException {
        Layer layer = null;
        Property data = this.getData();
        if (data != null) {
            layer = ImageHelper.createLayer((Item)data);
            if (layer != null && cropped) {
                this.crop(layer);
            }
            if (layer != null && resized) {
                this.resize(layer);
            }
            if (layer != null && rotated) {
                this.rotate(layer);
            }
        }
        return layer;
    }
}

