/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.text.Text;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class LanguageUtil {
    public static final Set<String> ISO_LANGUAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOLanguages())));
    public static final Set<String> ISO_COUNTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOCountries())));

    public static Locale getLocale(String code) {
        if (code == null) {
            return null;
        }
        String lang = null;
        String country = "";
        if (code.length() == 2) {
            lang = code.toLowerCase();
        } else if (code.length() == 5 && code.charAt(2) == '_') {
            lang = code.substring(0, 2).toLowerCase();
            country = code.substring(3).toUpperCase();
        }
        if (lang == null || !ISO_LANGUAGES.contains(lang)) {
            return null;
        }
        if (country.length() > 0 && !ISO_COUNTRIES.contains(country)) {
            return null;
        }
        return new Locale(lang, country);
    }

    public static String getLanguageRoot(String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return null;
        }
        path = path + "/";
        int idx = path.indexOf(47, 1);
        while (idx > 0) {
            String subPath = path.substring(0, idx);
            String name = Text.getName((String)subPath);
            Locale locale = LanguageUtil.getLocale(name);
            if (locale != null) {
                return subPath;
            }
            idx = path.indexOf(47, idx + 1);
        }
        return null;
    }
}

