/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.date;

import com.day.cq.commons.date.InvalidDateException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateUtil {
    private final int firstDayOfWeek;

    public DateUtil() {
        this.firstDayOfWeek = 2;
    }

    public DateUtil(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public final Calendar getLastYearStart() {
        Calendar c = this.getYearStart();
        c.add(1, -1);
        return c;
    }

    public final Calendar getYearStart() {
        Calendar c = this.getMonthStart();
        c.set(2, 0);
        return c;
    }

    public final Calendar getThreeMonthsAgo() {
        Calendar c = this.getToday();
        c.add(2, -3);
        return c;
    }

    public final Calendar getMonthStart() {
        Calendar c = this.getToday();
        c.set(5, 1);
        return c;
    }

    public final Calendar getWeekStart() {
        Calendar c = this.getToday();
        int firstDayOfWeek = c.getFirstDayOfWeek();
        int thisDayOfWeek = c.get(7);
        if (thisDayOfWeek < firstDayOfWeek) {
            firstDayOfWeek -= 7;
        }
        c.add(5, -(thisDayOfWeek - firstDayOfWeek));
        return c;
    }

    public final Calendar getToday() {
        Calendar c = this.getNow();
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        return c;
    }

    public final Calendar getNow() {
        Calendar now = Calendar.getInstance();
        now.setFirstDayOfWeek(this.firstDayOfWeek);
        return now;
    }

    public static Calendar parseISO8601(String iso8601Date) throws InvalidDateException {
        return DateUtil.parseISO8601(iso8601Date, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Calendar parseISO8601(String iso8601Date, TimeZone defaultTimeZone) throws InvalidDateException {
        StringTokenizer st = new StringTokenizer(iso8601Date, "-T:.+Z", true);
        if (defaultTimeZone == null) {
            defaultTimeZone = TimeZone.getDefault();
        }
        Calendar calendar = Calendar.getInstance(defaultTimeZone);
        calendar.clear();
        try {
            String tzID;
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!DateUtil.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!DateUtil.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!DateUtil.check(st, "T") || !st.hasMoreTokens()) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!DateUtil.check(st, ":") || !st.hasMoreTokens()) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new InvalidDateException("No seconds specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (tok.equals("+") || tok.equals("-")) {
                tzID = "GMT" + tok;
                if (!st.hasMoreTokens()) {
                    throw new InvalidDateException("Missing timezone hour field");
                }
                String tzhour = st.nextToken();
                if (!DateUtil.check(st, ":") || !st.hasMoreTokens()) {
                    throw new InvalidDateException("Missing timezone minute field");
                }
                String tzmin = st.nextToken();
                tzID = tzID + tzhour + ":" + tzmin;
            } else {
                if (!tok.equals("Z")) throw new InvalidDateException("only Z, + or - allowed in timezone");
                tzID = "GMT";
            }
            TimeZone tz = TimeZone.getTimeZone(tzID);
            if (tz.getID().equals("GMT") && !tzID.equals("GMT")) {
                throw new InvalidDateException("only Z, + or - allowed in timezone");
            }
            calendar.setTimeZone(tz);
            return calendar;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDateException("[" + ex.getMessage() + "] is not an integer");
        }
    }

    public static String getISO8601Date(Calendar calendar) {
        return DateUtil.getISO8601Date(calendar.getTime(), calendar.getTimeZone());
    }

    public static String getISO8601Date(Date date) {
        return DateUtil.getISO8601Date(date, TimeZone.getTimeZone("GMT"));
    }

    public static String getISO8601Date(Date date, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer(DateUtil.getISO8601DateNoTime(date, timeZone));
        buffer.append("T");
        buffer.append(DateUtil.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(DateUtil.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(DateUtil.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(DateUtil.threeDigit(calendar.get(14)));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String getISO8601DateAndTimeNoMillis(Calendar calendar) {
        return DateUtil.getISO8601DateAndTimeNoMillis(calendar.getTime(), calendar.getTimeZone());
    }

    public static String getISO8601DateAndTimeNoMillis(Date date) {
        return DateUtil.getISO8601DateAndTimeNoMillis(date, TimeZone.getTimeZone("GMT"));
    }

    public static String getISO8601DateAndTimeNoMillis(Date date, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer(DateUtil.getISO8601DateNoTime(date, timeZone));
        buffer.append("T");
        buffer.append(DateUtil.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(DateUtil.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(DateUtil.twoDigit(calendar.get(13)));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String getISO8601DateNoTime(Calendar calendar) {
        return DateUtil.getISO8601DateNoTime(calendar.getTime(), calendar.getTimeZone());
    }

    public static String getISO8601DateNoTime(Date date) {
        return DateUtil.getISO8601DateNoTime(date, TimeZone.getTimeZone("GMT"));
    }

    public static String getISO8601DateNoTime(Date date, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(DateUtil.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(DateUtil.twoDigit(calendar.get(5)));
        return buffer.toString();
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    private static String threeDigit(int i) {
        if (i >= 0 && i < 10) {
            return "00" + String.valueOf(i);
        }
        if (i < 100) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    private static boolean check(StringTokenizer st, String token) throws InvalidDateException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new InvalidDateException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }
}

