/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.JcrLabeledResource;
import com.day.cq.commons.LabeledResource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Class<LabeledResource> LR_CLASS = LabeledResource.class;
    private static final String[] ADAPTER_CLASSES = new String[]{LR_CLASS.getName()};
    private static final String[] ADAPTABLE_CLASSES = new String[]{Resource.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        this.log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        Node node;
        if (type == LR_CLASS && (node = (Node)resource.adaptTo(Node.class)) != null) {
            try {
                return (AdapterType)new JcrLabeledResource(node);
            }
            catch (RepositoryException e) {
                this.log.error("Error while creating JcrLabeledResource.", (Throwable)e);
            }
        }
        this.log.debug("Unable to adapt resource of {} to type {}", (Object)resource.getResourceType(), (Object)type.getName());
        return null;
    }
}

