/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.ConfigHelper;
import com.day.text.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.runmode.RunMode;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelperImpl
implements ConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigHelperImpl.class);
    private ConfigurationAdmin configAdmin;
    private SlingRepository repository;
    private RunMode runMode;

    public Configuration getConfiguration(ComponentContext ctx) throws IOException {
        Dictionary config = ctx.getProperties();
        String pid = (String)config.get("service.pid");
        if (pid == null) {
            log.error("Unable to retrieve config. no service.pid.");
            return null;
        }
        return this.getConfiguration(pid);
    }

    public Configuration getConfiguration(String servicePid) throws IOException {
        return this.configAdmin.getConfiguration(servicePid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJcrConfigPath(Configuration config) {
        if (config == null) {
            return null;
        }
        String alias = (String)config.getProperties().get("_alias_factory_pid");
        String factoryPid = config.getFactoryPid();
        String pid = config.getPid();
        StringBuffer query = new StringBuffer("/jcr:root//");
        if (factoryPid != null) {
            if (alias == null) {
                log.error("Unable to retrieve path for factory config {}. not alias. maybe not jcr based?", (Object)pid);
                return null;
            }
            query.append(factoryPid).append("-").append(alias);
        } else {
            query.append(pid);
        }
        Session session = null;
        try {
            log.debug("searching for: {}", (Object)query);
            session = this.repository.loginAdministrative(null);
            Query q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "xpath");
            QueryResult res = q.execute();
            NodeIterator iter = res.getNodes();
            ArrayList<String> paths = new ArrayList<String>();
            while (iter.hasNext()) {
                paths.add(iter.nextNode().getPath());
            }
            Collections.sort(paths);
            String path = null;
            log.error("found {} paths.", (Object)paths.size());
            if (paths.size() == 0) {
                log.error("Unable to retrieve path for config {}. no node found.", (Object)pid);
            } else if (paths.size() == 1) {
                path = (String)paths.iterator().next();
            } else {
                String defaultPath = null;
                for (String p : paths) {
                    String parentName = Text.getName((String)Text.getRelativeParent((String)p, (int)1));
                    int idx = parentName.lastIndexOf(46);
                    if (idx > 0) {
                        String rm = parentName.substring(idx + 1);
                        if (!this.runMode.isActive(new String[]{rm})) continue;
                        path = p;
                        continue;
                    }
                    defaultPath = p;
                }
                if (path == null) {
                    path = defaultPath;
                }
                if (path == null) {
                    log.error("No valid config path found for {}", (Object)pid);
                }
            }
            log.info("Lookup for {} found path: {}", (Object)pid, (Object)path);
            String string = path;
            return string;
        }
        catch (RepositoryException e) {
            log.error("Error while retrieving jcr path", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void bindRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    protected void unbindRunMode(RunMode runMode) {
        if (this.runMode == runMode) {
            this.runMode = null;
        }
    }

    protected void bindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unbindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

