/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.predicate.PredicateProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateProviderImpl
implements PredicateProvider {
    private final Logger log = LoggerFactory.getLogger(PredicateProviderImpl.class);
    private static String PRED_REF_NAME = "Predicate";
    private static String PREDICATE_NAME = "predicate.name";
    private ComponentContext osgiComponentContext;
    private List<ServiceReference> delayedRefs;
    private Map<String, Predicate> predicates = new HashMap<String, Predicate>();

    public Predicate getPredicate(String name) {
        return this.predicates.get(name);
    }

    protected void activate(ComponentContext componentContext) {
        this.osgiComponentContext = componentContext;
        if (this.osgiComponentContext != null && this.delayedRefs != null) {
            List<ServiceReference> list = this.delayedRefs;
            this.delayedRefs = null;
            for (ServiceReference ref : list) {
                this.initPredicate(ref);
            }
        }
        this.log.info("Predicate service activated.");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.log.info("Predicate service deactivated.");
    }

    protected void bindPredicate(ServiceReference ref) {
        if (this.osgiComponentContext == null) {
            if (this.delayedRefs == null) {
                this.delayedRefs = new LinkedList<ServiceReference>();
            }
            this.delayedRefs.add(ref);
        } else {
            this.initPredicate(ref);
        }
    }

    protected void unbindPredicate(ServiceReference ref) {
        String name = (String)ref.getProperty(PREDICATE_NAME);
        if (this.predicates.remove(name) == null) {
            this.log.warn("removing unregistered predicate {}", (Object)name);
        } else {
            this.log.info("unregistering predicate {}", (Object)name);
        }
    }

    private void initPredicate(ServiceReference ref) {
        Predicate pred = (Predicate)this.osgiComponentContext.locateService(PRED_REF_NAME, ref);
        String name = (String)ref.getProperty(PREDICATE_NAME);
        if (name == null) {
            this.log.error("initFilter: Missing name for predicate {}", (Object)ref);
            return;
        }
        this.log.info("registering predicate {}", (Object)name);
        this.predicates.put(name, pred);
    }
}

