/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.feed.AtomFeed;
import com.day.cq.commons.feed.Feed;
import com.day.cq.commons.feed.RssFeed;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

public class FeedRendererServlet
extends SlingSafeMethodsServlet {
    public static final String ATTR_NO_INCLUDE = "noinclude";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        String[] sels = req.getRequestPathInfo().getSelectors();
        boolean isEntry = req.getAttribute(ATTR_NO_INCLUDE) == null && req.getAttribute("org.apache.sling.api.include.servlet") != null || sels.length > 0 && "feedentry".equals(sels[0]);
        int maxCount = 30;
        try {
            Feed feed = this.getFeed(req, resp);
            resp.setContentType(feed.getContentType());
            resp.setCharacterEncoding(feed.getCharacterEncoding());
            if (isEntry) {
                feed.printEntry();
            } else {
                feed.printHeader();
                feed.printChildEntries(maxCount);
                feed.printFooter();
            }
        }
        catch (Exception e) {
            throw new ServletException("Error while rendering resource as feed: " + e.getMessage());
        }
    }

    protected Feed getFeed(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws RepositoryException {
        String[] sels = req.getRequestPathInfo().getSelectors();
        if (sels.length > 1 && "rss".equals(sels[1])) {
            return new RssFeed(req, resp);
        }
        return new AtomFeed(req, resp);
    }
}

