/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import java.util.Locale;

public class Language {
    private final Locale locale;
    private final String language;
    private final String country;

    public Language(Locale locale) {
        this.locale = locale;
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
    }

    public Language(String code) {
        int idx = code.indexOf(95);
        if (idx < 0) {
            this.language = code;
            this.country = "";
        } else {
            this.language = code.substring(0, idx);
            this.country = code.substring(idx + 1);
        }
        this.locale = new Locale(code);
    }

    public Language(Locale locale, String language, String country) {
        this.locale = locale;
        this.language = language;
        this.country = country;
    }

    public Language(String language, String country) {
        this.language = language;
        this.country = country;
        this.locale = new Locale(language, country);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguageCode() {
        return this.language;
    }

    public String getCountryCode() {
        return this.country;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.language);
        if (this.country.length() > 0) {
            sb.append("_").append(this.country);
        }
        return sb.toString();
    }

    public static Locale getLocale(String code) {
        if (code == null) {
            return null;
        }
        int idx = (code = code.replaceAll("-", "_")).indexOf(95);
        if (idx < 0) {
            return new Locale(code);
        }
        String language = code.substring(0, idx);
        String country = code.substring(idx + 1);
        if ((idx = country.indexOf(95)) < 0) {
            return new Locale(language, country);
        }
        return new Locale(language, country.substring(0, idx), country.substring(idx + 1));
    }
}

