/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import org.apache.sling.api.request.RequestPathInfo;

public class PathInfo
implements RequestPathInfo {
    private final String path;
    private final String selectorString;
    private final String[] selectors;
    private final String extension;
    private final String suffix;

    public PathInfo(String urlPath) {
        if (urlPath == null || !urlPath.startsWith("/")) {
            throw new IllegalArgumentException("Not an absolute path: " + urlPath);
        }
        int lastDot = urlPath.lastIndexOf(".");
        if (lastDot >= 0) {
            String selectorStr;
            String extPlusSuffix = urlPath.substring(lastDot + 1);
            urlPath = urlPath.substring(0, lastDot);
            int firstSlash = extPlusSuffix.indexOf("/");
            if (firstSlash >= 0) {
                this.extension = extPlusSuffix.substring(0, firstSlash);
                this.suffix = extPlusSuffix.substring(firstSlash);
            } else {
                this.extension = extPlusSuffix;
                this.suffix = null;
            }
            int lastSlash = urlPath.lastIndexOf("/");
            if (lastSlash >= 0) {
                selectorStr = urlPath.substring(lastSlash + 1);
                urlPath = urlPath.substring(0, lastSlash + 1);
            } else {
                selectorStr = urlPath;
            }
            int firstDot = selectorStr.indexOf(".");
            if (firstDot >= 0) {
                urlPath = urlPath + selectorStr.substring(0, firstDot);
                selectorStr = selectorStr.substring(firstDot + 1);
            } else {
                urlPath = urlPath + selectorStr;
                selectorStr = null;
            }
            this.path = urlPath;
            if (selectorStr == null) {
                this.selectorString = null;
                this.selectors = new String[0];
            } else {
                this.selectorString = selectorStr;
                this.selectors = selectorStr.split("\\.");
            }
        } else {
            this.path = urlPath;
            this.selectorString = null;
            this.selectors = new String[0];
            this.extension = null;
            this.suffix = null;
        }
    }

    public String getResourcePath() {
        return this.path;
    }

    public String getSelectorString() {
        return this.selectorString;
    }

    public String[] getSelectors() {
        return this.selectors;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

