/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.date;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Period;

public class RelativeTimeFormat {
    private static final String PATTERN_CHARS = "adDhmMrsyY";
    public static final String SHORT = "r a";
    public static final String MEDIUM = "D (r a)";
    public static final String FULL = "y M d h m s a";
    public static final String FACEBOOK = "r a";
    public static final String GMAIL = "Y";
    private final ResourceBundle bundle;
    private final char[] compiledPattern;
    private final Calendar calendar;
    private final Calendar now;
    private final SimpleDateFormat timeFmt;
    private final SimpleDateFormat shortFmt;
    private final SimpleDateFormat longFmt;
    private Locale locale;
    private Period period;

    public RelativeTimeFormat(String pattern) {
        this(pattern, null, null, null, null);
    }

    public RelativeTimeFormat(String pattern, String timePattern, String shortPattern, String longPattern, ResourceBundle bundle) {
        if (StringUtils.isBlank((String)pattern)) {
            throw new IllegalArgumentException("pattern may not be null or empty");
        }
        this.bundle = bundle;
        this.getLocale();
        this.compiledPattern = this.compile(pattern);
        this.calendar = Calendar.getInstance(this.locale);
        this.now = Calendar.getInstance(this.locale);
        this.timeFmt = new SimpleDateFormat(StringUtils.defaultIfEmpty((String)timePattern, (String)"HH:mm"), this.locale);
        this.shortFmt = new SimpleDateFormat(StringUtils.defaultIfEmpty((String)shortPattern, (String)"MMM d"), this.locale);
        this.longFmt = new SimpleDateFormat(StringUtils.defaultIfEmpty((String)longPattern, (String)"MM/dd/yyyy"), this.locale);
    }

    public String format(long start) {
        return this.format(start, System.currentTimeMillis());
    }

    public String format(long start, long end) {
        this.calendar.setTimeInMillis(start);
        this.now.setTimeInMillis(end);
        this.period = new Period(start, end);
        StringBuilder buffer = new StringBuilder();
        for (char c : this.compiledPattern) {
            int index = PATTERN_CHARS.indexOf(c);
            if (index >= 0) {
                this.fieldFormat(index, buffer);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private void fieldFormat(int index, StringBuilder buffer) {
        int years = this.period.getYears();
        int months = this.period.getMonths();
        int weeks = this.period.getWeeks();
        int days = weeks > 0 ? this.period.getDays() + weeks * 7 : this.period.getDays();
        int hours = this.period.getHours();
        int minutes = this.period.getMinutes();
        int seconds = this.period.getSeconds();
        switch (index) {
            case 0: {
                buffer.append(this.getLabel(1, "ago"));
                break;
            }
            case 1: {
                buffer.append(days).append(" ").append(this.getLabel(days, "day"));
                break;
            }
            case 2: {
                buffer.append(this.getDynamicDate(months, weeks, days));
                break;
            }
            case 3: {
                buffer.append(hours).append(" ").append(this.getLabel(hours, "hour"));
                break;
            }
            case 4: {
                buffer.append(minutes).append(" ").append(this.getLabel(minutes, "minute"));
                break;
            }
            case 5: {
                buffer.append(months).append(" ").append(this.getLabel(months, "month"));
                break;
            }
            case 6: {
                buffer.append(this.getRelative(years, months, weeks, days, hours, minutes, seconds));
                break;
            }
            case 7: {
                buffer.append(seconds).append(" ").append(this.getLabel(seconds, "second"));
                break;
            }
            case 8: {
                buffer.append(years).append(" ").append(this.getLabel(years, "year"));
                break;
            }
            case 9: {
                buffer.append(this.getDynamicDate(months, weeks, days));
                if (this.calendar.get(1) != this.now.get(1) || months != 0 || weeks >= 2) break;
                buffer.append(" (").append(this.getRelative(years, months, weeks, days, hours, minutes, seconds)).append(" ").append(this.getLabel(1, "ago")).append(")");
                break;
            }
        }
    }

    private String getRelative(int years, int months, int weeks, int days, int hours, int minutes, int seconds) {
        int count = 0;
        String label = "";
        if (0 < years) {
            count = weeks;
            label = this.getLabel(count, "year");
        } else if (0 < months) {
            count = months;
            label = this.getLabel(count, "month");
        } else if (0 < days) {
            count = 0 < weeks ? days + weeks * 7 : days;
            label = this.getLabel(count, "day");
        } else if (0 < hours) {
            count = hours;
            label = this.getLabel(count, "hour");
        } else if (0 < minutes) {
            count = minutes;
            label = this.getLabel(count, "minute");
        } else if (0 <= seconds) {
            count = seconds;
            label = this.getLabel(count, "second");
        }
        return count + " " + label;
    }

    private String getDynamicDate(int months, int weeks, int days) {
        if (this.calendar.get(1) < this.now.get(1)) {
            return this.longFmt.format(this.calendar.getTime());
        }
        if (months > 0 || weeks >= 2) {
            return this.shortFmt.format(this.calendar.getTime());
        }
        if (days > 0) {
            return this.shortFmt.format(this.calendar.getTime());
        }
        return this.timeFmt.format(this.calendar.getTime());
    }

    private char[] compile(String pattern) {
        StringBuilder buffer = new StringBuilder();
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                buffer.append(c);
                continue;
            }
            if (PATTERN_CHARS.indexOf(c) >= 0) {
                buffer.append(c);
                continue;
            }
            throw new IllegalArgumentException("illegal pattern character \"'" + c + "'");
        }
        return buffer.toString().toCharArray();
    }

    private String getLabel(int count, String key) {
        if (count > 1 || count < 1) {
            key = key + "s";
        }
        String s = null;
        if (null != this.bundle) {
            s = this.bundle.getString(key);
        }
        return StringUtils.defaultIfEmpty(s, (String)key);
    }

    private Locale getLocale() {
        if (null == this.locale && null != this.bundle) {
            this.locale = this.bundle.getLocale();
        } else if (null != this.locale) {
            return this.locale;
        }
        if (null == this.locale) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }
}

