/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.feed;

import com.day.cq.commons.feed.AbstractFeed;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

public class RssFeed
extends AbstractFeed {
    public RssFeed(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws RepositoryException {
        super(null, req, resp);
    }

    public RssFeed(Resource res, SlingHttpServletRequest req, SlingHttpServletResponse resp) throws RepositoryException {
        super(res, req, resp);
    }

    public void printHeader() throws IOException {
        this.initXml();
        this.xml.openDocument();
        this.xml.open("rss").attr("version", "2.0").attr("xmlns:atom", "http://www.w3.org/2005/Atom").open("channel").open("link", this.getHtmlLink(), false).close().open("atom:link").attr("rel", "self").attr("href", this.getHtmlLink()).close().open("title", this.getTitle(), false).close().open("description", this.getDescription(), false).close().open("pubDate", this.getPublishedDate(), false).close().open("generator", this.getGeneratorLink(), false).close();
        if (!"".equals(this.getLanguage())) {
            this.xml.open("language", this.getLanguage(), false).close();
        }
    }

    public void printEntry() throws IOException {
        String link = this.isFile() ? this.getFileLink() : this.getHtmlLink();
        String comments = this.isFile() ? "" : this.getCommentsLink();
        this.initXml();
        this.xml.omitXmlDeclaration(true);
        this.xml.open("item").open("link", link, false).close().open("comments", comments, false).close().open("guid", this.getFeedLink(), false).close().open("title", this.getTitle(), false).close().open("description", this.getDescription(), true).close().open("pubDate", this.getPublishedDate(), false).close().open("category", this.getTags(), false).close();
        if (!"".equals(this.getAuthorEmail())) {
            this.xml.open("author", this.getAuthorEmail(), false).close();
        }
        this.xml.tidyUp();
    }

    public String getContentType() {
        return "application/rss+xml";
    }

    String getFeedEntryPath(Resource res) {
        return res.getPath() + "." + "feedentry" + "." + "rss" + ".xml";
    }

    protected String getFeedLink() {
        return this.getUrlPrefix() + this.getNodePath() + "." + "feed" + "." + "rss" + ".xml";
    }

    protected String formatDate(Calendar calendar) {
        try {
            return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(calendar.getTime());
        }
        catch (Exception e) {
            return "";
        }
    }
}

