/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.Externalizer;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalizerImpl
implements Externalizer {
    private final Logger log = LoggerFactory.getLogger(ExternalizerImpl.class);
    private static final String HOST_CONFIG = "externalizer.host";
    private static final String CONTEXT_PATH_CONFIG = "externalizer.contextpath";
    private String host;
    private String contextPath;

    protected void activate(ComponentContext ctx) {
        this.host = OsgiUtil.toString(ctx.getProperties().get(HOST_CONFIG), (String)"localhost:4502");
        this.contextPath = OsgiUtil.toString(ctx.getProperties().get(CONTEXT_PATH_CONFIG), (String)"");
    }

    public void setConfig(String host, String contextPath) {
        this.host = host;
        this.contextPath = contextPath;
    }

    public String relativeLink(SlingHttpServletRequest request, String path) {
        return request.getResourceResolver().map((HttpServletRequest)request, path);
    }

    public String absoluteLink(SlingHttpServletRequest request, String scheme, String path) {
        return this.absoluteLink(request, null, scheme, path);
    }

    public String absoluteLink(ResourceResolver resolver, String scheme, String path) {
        return this.absoluteLink(null, resolver, scheme, path);
    }

    public String absoluteLink(String scheme, String path) {
        return this.absoluteLink(null, null, scheme, path);
    }

    public String absoluteLink(SlingHttpServletRequest request, ResourceResolver resolver, String scheme, String path) {
        URI uri;
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://");
        if (request != null && resolver == null) {
            resolver = request.getResourceResolver();
        }
        if ((uri = URI.create(resolver != null ? resolver.map(path) : path)).getAuthority() == null) {
            if (request != null) {
                url.append(ExternalizerImpl.getAuthority(scheme, request.getServerName(), request.getServerPort()));
            } else {
                url.append(this.host);
            }
        } else {
            url.append(uri.getAuthority());
        }
        if (request != null) {
            url.append(request.getContextPath());
        } else {
            url.append(this.contextPath);
        }
        url.append(uri.getPath());
        if (uri.getQuery() != null) {
            url.append("?");
            url.append(uri.getQuery());
        }
        if (uri.getFragment() != null) {
            url.append("#");
            url.append(uri.getFragment());
        }
        if (this.log.isDebugEnabled()) {
            if (request != null) {
                this.log.debug("externalizing absolute link (request scope): {} -> {}", (Object)path, (Object)url);
            } else {
                this.log.debug("externalizing absolute link (non-request scope): {} -> {}", (Object)path, (Object)url);
            }
        }
        return url.toString();
    }

    public static String getAuthority(String scheme, String host, int port) {
        if (port <= 0 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            return host;
        }
        return host + ":" + port;
    }
}

