/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.ProductInfo;
import com.day.cq.commons.ProductInfoService;
import com.day.cq.commons.Version;
import com.day.crx.CRXRepository;
import com.day.crx.License;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductInfoServiceImpl
implements ProductInfoService {
    private final Logger log = LoggerFactory.getLogger(ProductInfoServiceImpl.class);
    private static final String[] PATHS = new String[]{"/apps/", "/libs/"};
    private CRXRepository crxRepository;
    private SlingRepository repository;
    private Map<String, ProductInfo> cached = new HashMap<String, ProductInfo>();

    protected void activate(ComponentContext componentCtx) {
        this.cached.clear();
        ProductInfo info = this.getInfo();
        if (info == null) {
            this.log.error("Product infomation not found at /libs/cq/core/productinfo");
        } else {
            this.log.info("Product Info Service Started.");
            for (Map.Entry e : info.getProperties().entrySet()) {
                this.log.info("- {}: {}", e.getKey(), e.getValue());
            }
        }
    }

    public ProductInfo getInfo() {
        return this.getInfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductInfo getInfo(String name) {
        ProductInfo info = this.cached.get(name);
        if (info == null) {
            name = name == null || name.length() == 0 ? "cq/core/productinfo" : name + "/productinfo";
            Session admin = null;
            try {
                admin = this.repository.loginAdministrative(null);
                Node infoNode = null;
                for (String p : PATHS) {
                    if (!admin.nodeExists(p + name)) continue;
                    infoNode = admin.getNode(p + name);
                    break;
                }
                if (infoNode == null) {
                    this.log.warn("No product information node found for {}", (Object)name);
                } else {
                    HashMap props = new HashMap(new JcrPropertyMap(infoNode));
                    info = new InfoImpl((ValueMap)new ValueMapDecorator(props));
                    this.cached.put(name, info);
                }
            }
            catch (RepositoryException e) {
                this.log.error("Error while retrieving product information.", (Throwable)e);
            }
            finally {
                if (admin != null) {
                    admin.logout();
                }
            }
        }
        return info;
    }

    public License getLicense() {
        return this.crxRepository == null ? null : this.crxRepository.getLicense();
    }

    public String getLicenseId() {
        License lic = this.getLicense();
        return lic == null ? null : lic.getDownloadId();
    }

    protected void bindCrxRepository(CRXRepository cRXRepository) {
        this.crxRepository = cRXRepository;
    }

    protected void unbindCrxRepository(CRXRepository cRXRepository) {
        if (this.crxRepository == cRXRepository) {
            this.crxRepository = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static class InfoImpl
    implements ProductInfo {
        private final ValueMap props;

        private InfoImpl(ValueMap props) {
            this.props = props;
        }

        public String getName() {
            return (String)this.props.get("name", (Object)"");
        }

        public String getShortName() {
            return (String)this.props.get("shortName", (Object)"");
        }

        public Version getVersion() {
            return Version.create((String)this.props.get("version", (Object)""));
        }

        public String getShortVersion() {
            return (String)this.props.get("shortVersion", (Object)"");
        }

        public String getVendor() {
            return (String)this.props.get("vendor", (Object)"");
        }

        public String getVendorUrl() {
            return (String)this.props.get("vendorUrl", (Object)"");
        }

        public String getUrl() {
            return (String)this.props.get("url", (Object)"");
        }

        public ValueMap getProperties() {
            return this.props;
        }
    }
}

