/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.jcr;

import com.day.text.Text;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrUtil {
    private static final Logger log = LoggerFactory.getLogger(JcrUtil.class);
    public static final String[] STANDARD_LABEL_CHAR_MAPPING = new String[]{"_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "-", "_", "_", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_", "_", "_", "_", "_", "_", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_", "_", "_", "_", "_", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_", "_", "_", "_", "_", "_", "f", "_", "_", "_", "fi", "fi", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "y", "_", "_", "_", "_", "i", "c", "p", "o", "v", "_", "s", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "a", "a", "a", "a", "ae", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "d", "n", "o", "o", "o", "o", "oe", "x", "o", "u", "u", "u", "ue", "y", "b", "ss", "a", "a", "a", "a", "ae", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "o", "n", "o", "o", "o", "o", "oe", "_", "o", "u", "u", "u", "ue", "y", "b", "y"};
    public static final String[] HYPHEN_LABEL_CHAR_MAPPING = new String[STANDARD_LABEL_CHAR_MAPPING.length];
    public static final String NON_VALID_CHARS = "%/\\:*?\"[]|\n\t\r. ";

    public static String escapeIllegalJcrChars(String name) {
        StringBuffer buffer = new StringBuffer(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '%' || ch == '/' || ch == ':' || ch == '[' || ch == ']' || ch == '*' || ch == '\'' || ch == '\"' || ch == '|' || ch == '.' && name.length() < 3 || ch == ' ' && (i == 0 || i == name.length() - 1) || ch == '\t' || ch == '\r' || ch == '\n') {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String unescapeIllegalJcrChars(String name) {
        StringBuffer buffer = new StringBuffer(name.length());
        int i = name.indexOf(37);
        while (i > -1 && i + 2 < name.length()) {
            buffer.append(name.toCharArray(), 0, i);
            int a = Character.digit(name.charAt(i + 1), 16);
            int b = Character.digit(name.charAt(i + 2), 16);
            if (a > -1 && b > -1) {
                buffer.append((char)(a * 16 + b));
                name = name.substring(i + 3);
            } else {
                buffer.append('%');
                name = name.substring(i + 1);
            }
            i = name.indexOf(37);
        }
        buffer.append(name);
        return buffer.toString();
    }

    public static Node createPath(String absolutePath, String nodeType, Session session) throws RepositoryException {
        return JcrUtil.createPath(absolutePath, false, nodeType, nodeType, session, false);
    }

    public static Node createPath(String absolutePath, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        return JcrUtil.createPath(absolutePath, false, intermediateNodeType, nodeType, session, autoSave);
    }

    public static Node createUniquePath(String pathHint, String nodeType, Session session) throws RepositoryException {
        return JcrUtil.createPath(pathHint, true, nodeType, nodeType, session, false);
    }

    public static Node createPath(String absolutePath, boolean createUniqueLeaf, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        if (absolutePath == null || absolutePath.length() == 0 || "/".equals(absolutePath)) {
            return session.getRootNode();
        }
        return JcrUtil.createPath(session.getRootNode(), absolutePath.substring(1), createUniqueLeaf, intermediateNodeType, nodeType, session, autoSave);
    }

    public static Node createUniqueNode(Node parent, String nodeNameHint, String nodeType, Session session) throws RepositoryException {
        return JcrUtil.createPath(parent, nodeNameHint, true, nodeType, nodeType, session, false);
    }

    public static Node createPath(Node baseNode, String path, boolean createUniqueLeaf, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        if (!createUniqueLeaf && baseNode.hasNode(path)) {
            return baseNode.getNode(path);
        }
        Node node = baseNode;
        int pos = path.lastIndexOf(47);
        if (pos != -1) {
            StringTokenizer st = new StringTokenizer(path.substring(0, pos), "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!node.hasNode(token)) {
                    try {
                        node.addNode(token, intermediateNodeType);
                        if (autoSave) {
                            node.save();
                        }
                    }
                    catch (RepositoryException e) {
                        log.warn("Error while creating intermediate node", (Throwable)e);
                        node.refresh(false);
                    }
                }
                node = node.getNode(token);
            }
            path = path.substring(pos + 1);
        }
        if (!node.hasNode(path)) {
            node.addNode(path, nodeType);
            if (autoSave) {
                node.save();
            }
        } else if (createUniqueLeaf) {
            String leafNodeName;
            int i = 0;
            do {
                leafNodeName = path + String.valueOf(i);
                ++i;
            } while (node.hasNode(leafNodeName));
            Node leaf = node.addNode(leafNodeName, nodeType);
            if (autoSave) {
                node.save();
            }
            return leaf;
        }
        return node.getNode(path);
    }

    public static String createValidName(String title) {
        return JcrUtil.createValidName(title, STANDARD_LABEL_CHAR_MAPPING);
    }

    public static String createValidName(String title, String[] labelCharMapping) {
        char[] chrs = title.toCharArray();
        StringBuffer name = new StringBuffer(chrs.length);
        boolean prevEscaped = false;
        for (int idx = 0; idx < title.length() && name.length() < 64; ++idx) {
            char c = title.charAt(idx);
            String repl = "_";
            if (c >= '\u0000' && c < labelCharMapping.length) {
                repl = labelCharMapping[c];
            }
            if (repl.equals("_")) {
                if (!prevEscaped && name.length() < 16) {
                    name.append('_');
                }
                prevEscaped = true;
                continue;
            }
            name.append(repl);
            prevEscaped = false;
        }
        return name.toString();
    }

    public static String createValidChildName(Node node, String name) throws RepositoryException {
        String valid = JcrUtil.createValidName(name);
        if (node.hasNode(valid)) {
            String leafNodeName;
            int i = 0;
            do {
                leafNodeName = valid + String.valueOf(i);
                ++i;
            } while (node.hasNode(leafNodeName));
            return leafNodeName;
        }
        return valid;
    }

    public static boolean isValidName(String name) {
        if (name == null || name.equals("")) {
            return false;
        }
        for (int idx = 0; idx < name.length(); ++idx) {
            if (NON_VALID_CHARS.indexOf(name.charAt(idx)) < 0 && name.charAt(idx) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static Value createValue(Object value, Session session) throws RepositoryException {
        ValueFactory fac = session.getValueFactory();
        Object val = value instanceof Calendar ? fac.createValue((Calendar)value) : (value instanceof InputStream ? fac.createValue((InputStream)value) : (value instanceof Node ? fac.createValue((Node)value) : (value instanceof Long ? fac.createValue(((Long)value).longValue()) : (value instanceof Number ? fac.createValue(((Number)value).doubleValue()) : (value instanceof Boolean ? fac.createValue(((Boolean)value).booleanValue()) : (value instanceof String ? fac.createValue((String)value) : null))))));
        return val;
    }

    public static void setProperty(Node node, String propertyName, Object propertyValue) throws RepositoryException {
        if (propertyValue == null) {
            node.setProperty(propertyName, (String)null);
        } else if (propertyValue.getClass().isArray()) {
            Object[] values = (Object[])propertyValue;
            Value[] setValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                setValues[i] = JcrUtil.createValue(values[i], node.getSession());
            }
            node.setProperty(propertyName, setValues);
        } else {
            node.setProperty(propertyName, JcrUtil.createValue(propertyValue, node.getSession()));
        }
    }

    public static Item copy(Item src, Node dstParent, String name) throws RepositoryException {
        if (src.isNode()) {
            return JcrUtil.copy((Node)src, dstParent, name);
        }
        return JcrUtil.copy((Property)src, dstParent, name);
    }

    public static Node copy(Node src, Node dstParent, String name) throws RepositoryException {
        return JcrUtil.copy(src, dstParent, name, false);
    }

    public static Node copy(Node src, Node dstParent, String name, boolean bestEffort) throws RepositoryException {
        if (name == null) {
            name = src.getName();
        }
        if (dstParent.hasNode(name)) {
            dstParent.getNode(name).remove();
        }
        Node dst = dstParent.addNode(name, src.getPrimaryNodeType().getName());
        for (NodeType mix : src.getMixinNodeTypes()) {
            try {
                dst.addMixin(mix.getName());
            }
            catch (RepositoryException e) {
                if (bestEffort) continue;
                throw e;
            }
        }
        PropertyIterator iter = src.getProperties();
        while (iter.hasNext()) {
            try {
                JcrUtil.copy(iter.nextProperty(), dst, null);
            }
            catch (RepositoryException e) {
                if (bestEffort) continue;
                throw e;
            }
        }
        iter = src.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            if (n.getDefinition().isProtected()) continue;
            try {
                JcrUtil.copy(n, dst, null, bestEffort);
            }
            catch (RepositoryException e) {
                if (bestEffort) continue;
                throw e;
            }
        }
        return dst;
    }

    public static Property copy(Property src, Node dstParent, String name) throws RepositoryException {
        if (!src.getDefinition().isProtected()) {
            if (name == null) {
                name = src.getName();
            }
            if (dstParent.hasProperty(name)) {
                dstParent.getProperty(name).remove();
            }
            if (src.getDefinition().isMultiple()) {
                return dstParent.setProperty(name, src.getValues());
            }
            return dstParent.setProperty(name, src.getValue());
        }
        return null;
    }

    public static boolean setChildNodeOrder(Node parent, String nameList) throws RepositoryException {
        return nameList != null && JcrUtil.setChildNodeOrder(parent, Text.explode((String)nameList, (int)44));
    }

    public static boolean setChildNodeOrder(Node parent, String[] names) throws RepositoryException {
        if (names.length > 1 && parent.getPrimaryNodeType().hasOrderableChildNodes()) {
            if (!parent.isCheckedOut()) {
                log.warn("Unable to restore order of a checked-in node: " + parent.getPath());
                return false;
            }
            String last = null;
            List<String> list = Arrays.asList(names);
            ListIterator<String> iter = list.listIterator(list.size());
            while (iter.hasPrevious()) {
                String prev = iter.previous();
                if (!parent.hasNode(prev)) continue;
                log.debug("ordering {} before {}", (Object)prev, last);
                parent.orderBefore(prev, last);
                last = prev;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyResource(Session session, String path, Writer out) throws IOException, RepositoryException {
        int n;
        InputStream is = null;
        Binary b = null;
        try {
            Node content = session.getNode(path + "/" + "jcr:content");
            b = content.getProperty("jcr:data").getBinary();
            is = b.getStream();
            String encoding = content.hasProperty("jcr:encoding") ? content.getProperty("jcr:encoding").getString() : "utf-8";
            InputStreamReader r = new InputStreamReader(is, encoding);
            n = IOUtils.copy((Reader)r, (Writer)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            if (b != null) {
                b.dispose();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        if (b != null) {
            b.dispose();
        }
        return n;
    }

    static {
        for (int i = 0; i < HYPHEN_LABEL_CHAR_MAPPING.length; ++i) {
            String c = STANDARD_LABEL_CHAR_MAPPING[i];
            if (i != 95 && c.equals("_")) {
                c = "-";
            }
            JcrUtil.HYPHEN_LABEL_CHAR_MAPPING[i] = c;
        }
    }
}

