/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.commons.servlets.AbstractPredicateServlet;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractListServlet
extends AbstractPredicateServlet {
    protected static final long serialVersionUID = 2138470595710406273L;
    public static final String TIDY = "tidy";
    public static final String PAGE_START = "start";
    public static final String PAGE_LIMIT = "limit";
    public static final String SORT_KEY = "sort";
    public static final String SORT_DIR = "dir";
    public static final String SORT_ASCENDING = "ASC";
    public static final String SORT_DESCENDING = "DESC";
    public static final String PROP = "prop";
    protected static final String DEFAULT_TIDY = "true";
    protected static final String DEFAULT_SORT_KEY = "index";
    protected static final String DEFAULT_SORT_DIR = "ASC";
    protected static final String CONTENT_TYPE = "application/json";
    protected static final String ENCODING = "utf-8";
    protected SlingRepository repository;
    protected Session admin;

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        try {
            List<ListItem> items = this.getItems(request, predicate);
            int total = items.size();
            items = this.processItems(request, items, total);
            String[] customProps = request.getParameterValues(PROP);
            this.write(request, response, items, customProps, total);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected List<ListItem> getItems(SlingHttpServletRequest request, Predicate predicate) throws Exception {
        return null;
    }

    protected List<ListItem> processItems(SlingHttpServletRequest request, List<ListItem> items, int total) {
        return this.applyPaging(request, this.applySorting(request, items), total);
    }

    protected List<ListItem> applySorting(SlingHttpServletRequest request, List<ListItem> items) {
        String sortDir;
        String sortKey = request.getParameter(SORT_KEY) != null ? request.getParameter(SORT_KEY) : DEFAULT_SORT_KEY;
        String string = sortDir = request.getParameter(SORT_DIR) != null ? request.getParameter(SORT_DIR) : "ASC";
        if (!DEFAULT_SORT_KEY.equals(sortKey) || !"ASC".equals(sortDir)) {
            Collections.sort(items, new ListItemComparator(sortKey));
            if (SORT_DESCENDING.equals(sortDir)) {
                Collections.reverse(items);
            }
        }
        return items;
    }

    protected List<ListItem> applyPaging(SlingHttpServletRequest request, List<ListItem> items, int total) {
        int start = 0;
        int end = Integer.MAX_VALUE;
        if (request.getParameter(PAGE_START) != null) {
            try {
                start = Integer.parseInt(request.getParameter(PAGE_START));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (request.getParameter(PAGE_LIMIT) != null) {
            try {
                end = Integer.parseInt(request.getParameter(PAGE_LIMIT)) + start;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (start > 0 || total > end - start) {
            if (start > total - 1) {
                start = total;
            }
            if (end > total - 1) {
                end = total;
            }
            items = items.subList(start, end);
        }
        return items;
    }

    protected void write(SlingHttpServletRequest request, SlingHttpServletResponse response, List<ListItem> listItems, String[] customProps, int total) throws Exception {
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(ENCODING);
        TidyJSONWriter out = new TidyJSONWriter(response.getWriter());
        out.setTidy(DEFAULT_TIDY.equals(request.getParameter(TIDY)));
        out.object();
        out.key("pages");
        out.array();
        for (ListItem item : listItems) {
            item.write(out, customProps);
        }
        out.endArray();
        out.key("results").value((long)total);
        out.endObject();
    }

    protected void writeKey(JSONWriter out, String key, Object value) throws JSONException {
        out.key(key).value(value);
    }

    protected void writeOptionalKey(JSONWriter out, String key, Object value) throws JSONException {
        if (value != null) {
            this.writeKey(out, key, value);
        }
    }

    protected void writeOptionalDateKey(JSONWriter out, String key, Calendar value) throws JSONException {
        if (value != null) {
            out.key(key).value(value.getTimeInMillis());
        }
    }

    protected void writeCustomProperties(JSONWriter out, Resource resource, String[] customProps) throws JSONException {
        ValueMap props;
        if (customProps != null && (props = (ValueMap)resource.adaptTo(ValueMap.class)) != null) {
            for (String name : customProps) {
                this.writeOptionalKey(out, name, props.get(name, null));
            }
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        this.admin = this.repository.loginAdministrative(null);
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.admin != null && this.admin.isLive()) {
            this.admin.logout();
            this.admin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListItemComparator
    implements Comparator<ListItem> {
        private String compareField;

        public ListItemComparator(String compareField) {
            this.compareField = compareField;
        }

        @Override
        public int compare(ListItem o1, ListItem o2) {
            try {
                Object v1 = o1.getClass().getField(this.compareField).get(o1);
                Object v2 = o2.getClass().getField(this.compareField).get(o2);
                if (v1 instanceof String && v2 instanceof String) {
                    return ((String)v1).compareTo((String)v2);
                }
                if (v1 instanceof Integer && v2 instanceof Integer) {
                    int int2;
                    int int1 = (Integer)v1;
                    return int1 > (int2 = ((Integer)v2).intValue()) ? 1 : (int1 != int2 ? -1 : 0);
                }
                if (v1 instanceof Long && v2 instanceof Long) {
                    long long2;
                    long long1 = (Long)v1;
                    return long1 > (long2 = ((Long)v2).longValue()) ? 1 : (long1 != long2 ? -1 : 0);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return 0;
        }
    }

    public static interface ListItem {
        public static final String INDEX = "index";
        public static final String PATH = "path";
        public static final String LABEL = "label";
        public static final String TYPE = "type";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String LAST_MODIFIED = "lastModified";
        public static final String LAST_MODIFIED_BY = "lastModifiedBy";
        public static final String LOCKED_BY = "lockedBy";
        public static final String MONTHLY_HITS = "monthlyHits";
        public static final String REPLICATION = "replication";
        public static final String REPLICATION_NUM_QUEUED = "numQueued";
        public static final String REPLICATION_ACTION = "action";
        public static final String REPLICATION_PUBLISHED = "published";
        public static final String REPLICATION_PUBLISHED_BY = "publishedBy";
        public static final String IN_WORKFLOW = "inWorkflow";
        public static final String WORKFLOWS = "workflows";
        public static final String WORKFLOW_MODEL = "model";
        public static final String WORKFLOW_STARTED = "started";
        public static final String WORKFLOW_STARTED_BY = "startedBy";
        public static final String WORKFLOW_SUSPENDED = "suspended";
        public static final String WORKFLOW_WORK_ITEMS = "workItems";
        public static final String WORKFLOW_WORK_ITEM_TITLE = "item";
        public static final String WORKFLOW_WORK_ITEM_ASSIGNEE = "assignee";
        public static final String SCHEDULED_TASKS = "scheduledTasks";
        public static final String SCHEDULED_TASK_VERSION = "version";
        public static final String SCHEDULED_TASK_SCHEDULED = "scheduled";
        public static final String SCHEDULED_TASK_SCHEDULED_BY = "scheduledBy";
        public static final String SCHEDULED_TASK_TYPE = "type";
        public static final String SCHEDULED_ACTIVATION_WORKFLOW_ID = "/etc/workflow/models/scheduled_activation/jcr:content/model";
        public static final String SCHEDULED_DEACTIVATION_WORKFLOW_ID = "/etc/workflow/models/scheduled_deactivation/jcr:content/model";

        public void write(JSONWriter var1, String[] var2) throws Exception;
    }
}

