/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.TidyJsonItemWriter;
import com.day.cq.commons.servlets.AbstractPredicateServlet;
import java.io.IOException;
import javax.jcr.Node;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;

public class TidyJsonServlet
extends AbstractPredicateServlet {
    private static final long serialVersionUID = -5306185798911938807L;
    public static final String INFINITY = "infinity";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        Node node;
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        String[] sels = req.getRequestPathInfo().getSelectors();
        int depth = 0;
        if (sels.length > 1) {
            if (sels[1].equals(INFINITY)) {
                depth = Integer.MAX_VALUE;
            } else {
                try {
                    depth = Integer.parseInt(sels[1]);
                }
                catch (NumberFormatException e) {
                    throw new ServletException("Invalid depth specifier: " + sels[1]);
                }
            }
        }
        if ((node = (Node)req.getResource().adaptTo(Node.class)) == null) {
            throw new ServletException("Resource not adaptable to node: " + req.getResource().getPath());
        }
        TidyJsonItemWriter w = new TidyJsonItemWriter(null);
        w.setTidy(true);
        try {
            w.dump(node, resp.getWriter(), depth);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected int selectorPredicateStart() {
        return 2;
    }
}

