/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class PathInfo
implements RequestPathInfo {
    private final String path;
    private final String selectorString;
    private final String[] selectors;
    private final String extension;
    private final String suffix;

    public PathInfo(String urlPath) {
        if (urlPath == null || !urlPath.startsWith("/")) {
            throw new IllegalArgumentException("Not an absolute path: " + urlPath);
        }
        int lastDot = urlPath.lastIndexOf(".");
        if (lastDot >= 0) {
            String selectorStr;
            String extPlusSuffix = urlPath.substring(lastDot + 1);
            urlPath = urlPath.substring(0, lastDot);
            int firstSlash = extPlusSuffix.indexOf("/");
            if (firstSlash >= 0) {
                this.extension = extPlusSuffix.substring(0, firstSlash);
                this.suffix = extPlusSuffix.substring(firstSlash);
            } else {
                this.extension = extPlusSuffix;
                this.suffix = null;
            }
            int lastSlash = urlPath.lastIndexOf("/");
            if (lastSlash >= 0) {
                selectorStr = urlPath.substring(lastSlash + 1);
                urlPath = urlPath.substring(0, lastSlash + 1);
            } else {
                selectorStr = urlPath;
            }
            int firstDot = selectorStr.indexOf(".");
            if (firstDot >= 0) {
                urlPath = urlPath + selectorStr.substring(0, firstDot);
                selectorStr = selectorStr.substring(firstDot + 1);
            } else {
                urlPath = urlPath + selectorStr;
                selectorStr = null;
            }
            this.path = urlPath;
            if (selectorStr == null) {
                this.selectorString = null;
                this.selectors = new String[0];
            } else {
                this.selectorString = selectorStr;
                this.selectors = selectorStr.split("\\.");
            }
        } else {
            this.path = urlPath;
            this.selectorString = null;
            this.selectors = new String[0];
            this.extension = null;
            this.suffix = null;
        }
    }

    public PathInfo(ResourceResolver resolver, String urlPath) {
        Resource resource = resolver.resolve(urlPath);
        if (null != resource) {
            String info = resource.getResourceMetadata().getResolutionPathInfo();
            int slashIndex = StringUtils.indexOf((String)info, (String)"/");
            this.suffix = slashIndex >= 0 ? StringUtils.substring((String)info, (int)(slashIndex + 1)) : null;
            info = StringUtils.chomp((String)info, (String)("/" + this.suffix));
            int extIndex = StringUtils.lastIndexOf((String)info, (String)".");
            this.extension = extIndex >= 0 ? StringUtils.substring((String)info, (int)(extIndex + 1)) : null;
            this.selectorString = info = StringUtils.chomp((String)info, (String)("." + this.extension));
            this.selectors = StringUtils.split((String)info, (String)".");
            this.path = resolver.map(resource.getPath());
        } else {
            this.path = urlPath;
            this.selectorString = null;
            this.selectors = new String[0];
            this.extension = null;
            this.suffix = null;
        }
    }

    public String getResourcePath() {
        return this.path;
    }

    public String getSelectorString() {
        return this.selectorString;
    }

    public String[] getSelectors() {
        return this.selectors;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

