/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.DiffService;
import com.day.cq.commons.impl.WordsElementsFactory;
import com.day.util.diff.ChangeListener;
import com.day.util.diff.Document;
import com.day.util.diff.DocumentDiff;
import com.day.util.diff.DocumentSource;
import com.day.util.diff.ElementsFactory;
import org.osgi.service.component.ComponentContext;

public class DefaultDiffService
implements DiffService {
    private static final String ADDED_MARKER_CSS_CLASS = "addMarkerCssClass";
    private static final String REMOVED_MARKER_CSS_CLASS = "removedMarkerCssClass";
    private static final String DEFAULT_ADDED_MARKER_CSS_CLASS = "textAdded";
    private static final String DEFAULT_REMOVED_MARKER_CSS_CLASS = "textRemoved";
    private final Configuration configuration = new Configuration();
    private static final DocumentSource DOCUMENT_SOURCE = new SimpleDocumentSource("DUMMY", "DUMMY");

    protected void activate(ComponentContext context) {
        String removeMarker;
        String addMarker = (String)context.getProperties().get(ADDED_MARKER_CSS_CLASS);
        if (addMarker == null) {
            addMarker = DEFAULT_ADDED_MARKER_CSS_CLASS;
        }
        if ((removeMarker = (String)context.getProperties().get(REMOVED_MARKER_CSS_CLASS)) == null) {
            removeMarker = DEFAULT_REMOVED_MARKER_CSS_CLASS;
        }
        this.configuration.inPostfix = "</ins>";
        this.configuration.inPrefix = addMarker.length() == 0 ? "<ins>" : "<ins class='" + addMarker + "'>";
        this.configuration.outPostfix = "</del>";
        this.configuration.outPrefix = removeMarker.length() == 0 ? "<del>" : "<del class='" + removeMarker + "'>";
    }

    public String diff(String origText, String diffText, boolean isRichText) {
        if (origText == null || origText.trim().length() == 0) {
            if (diffText == null || diffText.trim().length() == 0) {
                return "";
            }
            return this.wrapText(diffText, this.configuration.outPrefix, this.configuration.outPostfix);
        }
        if (diffText == null || diffText.trim().length() == 0) {
            return this.wrapText(origText, this.configuration.inPrefix, this.configuration.inPostfix);
        }
        ElementsFactory origEF = WordsElementsFactory.create(origText);
        ElementsFactory otherEF = WordsElementsFactory.create(diffText);
        DocumentDiff diff = new DocumentDiff(new Document(DOCUMENT_SOURCE, origEF), new Document(DOCUMENT_SOURCE, otherEF));
        DiffChangeListener changeListener = new DiffChangeListener(this.configuration, origEF.getElements(), otherEF.getElements(), origText, diffText);
        diff.showChanges((ChangeListener)changeListener, 0);
        return changeListener.getText();
    }

    private String wrapText(String text, String pre, String post) {
        if (!text.startsWith("<p>")) {
            return pre + text + post;
        }
        String replaced = text.replace("<p>", "<p>" + pre);
        replaced = replaced.replace("</p>", post + "</p>");
        return replaced;
    }

    private static final class Configuration {
        public String inPrefix = "<ins>";
        public String inPostfix = "</ins>";
        public String outPrefix = "<del>";
        public String outPostfix = "</del>";

        private Configuration() {
        }
    }

    private static final class SimpleDocumentSource
    implements DocumentSource {
        private final String label;
        private final String location;

        public SimpleDocumentSource(String label, String location) {
            this.label = label;
            this.location = location;
        }

        public String getLabel() {
            return this.label;
        }

        public String getLocation() {
            return this.location;
        }
    }

    private static final class DiffChangeListener
    implements ChangeListener {
        private final Document.Element[] origElements;
        private final Document.Element[] diffElements;
        private StringBuilder text;
        private int lastOffset;
        private final Configuration configuration;
        private final String diffText;
        private boolean addedTagAtEnd = false;

        public DiffChangeListener(Configuration configuration, Document.Element[] origElements, Document.Element[] diffElements, String origText, String diffText) {
            this.origElements = origElements;
            this.diffElements = diffElements;
            this.text = new StringBuilder(origText);
            this.diffText = diffText;
            this.configuration = configuration;
            this.lastOffset = origElements.length > 0 ? origElements[origElements.length - 1].getString().length() : 0;
        }

        public String getText() {
            return this.text.toString();
        }

        private void compact(String first, String second, boolean removeIndex) {
            int pos1;
            int start = 0;
            while ((pos1 = this.text.indexOf(first, start)) != -1) {
                int end;
                int begin = pos1 + first.length();
                int wordIndex = -1;
                if (removeIndex) {
                    int endIndex = this.text.indexOf(":", begin);
                    wordIndex = Integer.valueOf(this.text.substring(begin, endIndex));
                    this.text.delete(begin, endIndex + 1);
                }
                if ((end = this.text.indexOf(second, begin)) != -1) {
                    boolean found = true;
                    for (int i = begin; i < end; ++i) {
                        char c = this.text.charAt(i);
                        if (c != '<' && c != '>' && !Character.isLetterOrDigit(c)) continue;
                        found = false;
                        break;
                    }
                    if (found) {
                        int endIndex;
                        this.text.delete(end, end + second.length());
                        this.text.delete(pos1, begin);
                        if (wordIndex == -1) continue;
                        WordsElementsFactory.WordElement previous = (WordsElementsFactory.WordElement)this.diffElements[wordIndex];
                        WordsElementsFactory.WordElement next = (WordsElementsFactory.WordElement)this.diffElements[wordIndex + 1];
                        int startIndex = previous.getIndex() + previous.getString().length();
                        if (startIndex >= (endIndex = next.getIndex())) continue;
                        this.text.insert(pos1, this.diffText.substring(startIndex, endIndex));
                        continue;
                    }
                    start = begin;
                    continue;
                }
                start = this.text.length();
            }
        }

        public void onDeleted(int leftIdx, int rightIdx, Document.Element elem) {
            int startPos = ((WordsElementsFactory.WordElement)this.origElements[leftIdx]).getIndex();
            int len = elem.getString().length();
            int oldLen = this.text.length();
            this.text.insert(startPos + len, this.configuration.inPostfix);
            this.text.insert(startPos, this.configuration.inPrefix);
            int diffLen = this.text.length() - oldLen;
            ((WordsElementsFactory.WordElement)this.origElements[leftIdx]).incrementIndex(diffLen + len);
            for (int i = leftIdx + 1; i < this.origElements.length; ++i) {
                ((WordsElementsFactory.WordElement)this.origElements[i]).incrementIndex(diffLen);
            }
        }

        public void onInserted(int leftIdx, int rightIdx, Document.Element elem) {
            if (leftIdx >= this.origElements.length) {
                int pos = ((WordsElementsFactory.WordElement)this.origElements[this.origElements.length - 1]).getIndex() + this.lastOffset;
                int oldLen = this.text.length();
                this.text.insert(pos, ':');
                this.text.insert(pos, rightIdx);
                this.text.insert(pos, this.configuration.outPostfix);
                this.text.insert(pos, elem.getString());
                this.text.insert(pos, this.configuration.outPrefix);
                if (!this.addedTagAtEnd) {
                    this.text.insert(pos, ' ');
                    this.addedTagAtEnd = true;
                }
                this.lastOffset += this.text.length() - oldLen;
                return;
            }
            int startPos = ((WordsElementsFactory.WordElement)this.origElements[leftIdx]).getIndex();
            int oldLen = this.text.length();
            this.text.insert(startPos, ':');
            this.text.insert(startPos, rightIdx);
            this.text.insert(startPos, this.configuration.outPostfix);
            this.text.insert(startPos, elem.getString());
            this.text.insert(startPos, this.configuration.outPrefix);
            int diffLen = this.text.length() - oldLen;
            for (int i = leftIdx; i < this.origElements.length; ++i) {
                ((WordsElementsFactory.WordElement)this.origElements[i]).incrementIndex(diffLen);
            }
        }

        public void onDocumentsEnd(Document left, Document right) {
            this.compact(this.configuration.inPostfix, this.configuration.inPrefix, false);
            this.compact(this.configuration.outPostfix, this.configuration.outPrefix, true);
        }

        public void onDocumentsStart(Document left, Document right) {
        }

        public void onChangeEnd() {
        }

        public void onChangeStart(int leftElem, int leftLen, int rightElem, int rightLen) {
        }

        public void onUnmodified(int leftIdx, int rightIdx, Document.Element elem) {
        }
    }
}

