/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.Externalizer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalizerImpl
implements Externalizer {
    private final Logger log = LoggerFactory.getLogger(ExternalizerImpl.class);
    private static final String DEFAULT_SCHEME = "http";
    private static final String SCHEME_SEP = "://";
    private static final String DEFAULT_LOCAL_DOMAIN = "local http://localhost:4502";
    private static final String DEFAULT_AUTHOR_DOMAIN = "author http://localhost:4502";
    private static final String DEFAULT_PUBLISH_DOMAIN = "publish http://localhost:4503";
    private static final String[] DEFAULT_DOMAINS = new String[]{"local http://localhost:4502", "author http://localhost:4502", "publish http://localhost:4503"};
    private static final String DOMAINS_CONFIG = "externalizer.domains";
    @Deprecated
    private static final String HOST_CONFIG = "externalizer.host";
    @Deprecated
    private static final String CONTEXT_PATH_CONFIG = "externalizer.contextpath";
    private Map<String, URI> domains = new HashMap<String, URI>();

    protected void activate(ComponentContext ctx) {
        this.domains = this.parseDomainConfig(OsgiUtil.toStringArray(ctx.getProperties().get(DOMAINS_CONFIG), (String[])DEFAULT_DOMAINS));
        this.handleLegacyConfig(OsgiUtil.toString(ctx.getProperties().get(HOST_CONFIG), (String)"").trim(), OsgiUtil.toString(ctx.getProperties().get(CONTEXT_PATH_CONFIG), (String)"").trim());
    }

    public void setConfig(String host, String contextPath, String[] domains) {
        this.domains = this.parseDomainConfig(domains == null ? DEFAULT_DOMAINS : domains);
        this.handleLegacyConfig(host == null ? "" : host.trim(), contextPath == null ? "" : contextPath.trim());
    }

    private void handleLegacyConfig(String host, String contextPath) {
        if (host.length() > 0) {
            try {
                this.domains.put("local", URI.create("http://" + host.trim() + contextPath.trim()));
            }
            catch (Exception e) {
                this.log.error("Invalid host and/or context path configuration: '{}' '{}'", (Object)host, (Object)contextPath);
            }
        }
    }

    private Map<String, URI> parseDomainConfig(String[] domainCfgs) {
        HashMap<String, URI> domains = new HashMap<String, URI>();
        if (domainCfgs == null) {
            return domains;
        }
        for (String domainCfg : domainCfgs) {
            int splitAt = (domainCfg = domainCfg.trim()).indexOf(32);
            if (splitAt <= 0) continue;
            String name = domainCfg.substring(0, splitAt);
            try {
                String domain = domainCfg.substring(splitAt + 1);
                if (!domain.contains(SCHEME_SEP)) {
                    domain = "http://" + domain;
                }
                domains.put(name, URI.create(domain));
            }
            catch (IllegalArgumentException e) {
                this.log.error("Invalid URI in domain configuration '{}'", (Object)domainCfg);
            }
        }
        return domains;
    }

    private static String getAuthority(String scheme, String host, int port) {
        if (port <= 0 || DEFAULT_SCHEME.equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            return host;
        }
        return host + ":" + port;
    }

    @Override
    public String relativeLink(SlingHttpServletRequest request, String path) {
        return request.getResourceResolver().map((HttpServletRequest)request, path);
    }

    @Override
    public String absoluteLink(SlingHttpServletRequest request, String scheme, String path) {
        return this.absoluteLink(request, null, scheme, path);
    }

    private String absoluteLink(SlingHttpServletRequest request, ResourceResolver resolver, String scheme, String path) {
        URI uri;
        if (request == null) {
            return this.externalLink(resolver, "local", scheme, path);
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme).append(SCHEME_SEP);
        if (resolver == null) {
            resolver = request.getResourceResolver();
        }
        if ((uri = URI.create(resolver != null ? resolver.map(path) : path)).getAuthority() == null) {
            url.append(ExternalizerImpl.getAuthority(scheme, request.getServerName(), request.getServerPort()));
        } else {
            url.append(uri.getAuthority());
        }
        url.append(request.getContextPath());
        url.append(uri.getPath());
        if (uri.getQuery() != null) {
            url.append("?");
            url.append(uri.getQuery());
        }
        if (uri.getFragment() != null) {
            url.append("#");
            url.append(uri.getFragment());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("externalizing absolute link (request scope): {} -> {}", (Object)path, (Object)url);
        }
        return url.toString();
    }

    @Override
    @Deprecated
    public String absoluteLink(ResourceResolver resolver, String scheme, String path) {
        return this.externalLink(resolver, "local", scheme, path);
    }

    @Override
    @Deprecated
    public String absoluteLink(String scheme, String path) {
        return this.externalLink(null, "local", scheme, path);
    }

    @Override
    public String externalLink(ResourceResolver resolver, String domain, String path) {
        return this.externalLink(resolver, domain, null, path);
    }

    @Override
    public String externalLink(ResourceResolver resolver, String domain, String scheme, String path) {
        if (domain == null) {
            throw new NullPointerException("Argument 'domain' is null");
        }
        URI domainURI = this.domains.get(domain);
        if (domainURI == null) {
            throw new IllegalArgumentException("Could not find configuration for domain '" + domain + "'");
        }
        StringBuilder url = new StringBuilder();
        if (scheme == null && (scheme = domainURI.getScheme()) == null) {
            scheme = DEFAULT_SCHEME;
        }
        url.append(scheme).append(SCHEME_SEP);
        URI mapped = URI.create(resolver != null ? resolver.map(path) : path);
        if (mapped.getAuthority() == null) {
            url.append(ExternalizerImpl.getAuthority(scheme, domainURI.getHost(), domainURI.getPort()));
        } else {
            url.append(mapped.getAuthority());
        }
        if (domainURI.getPath() != null) {
            url.append(domainURI.getPath());
        }
        url.append(mapped.getPath());
        if (mapped.getQuery() != null) {
            url.append("?");
            url.append(mapped.getQuery());
        }
        if (mapped.getFragment() != null) {
            url.append("#");
            url.append(mapped.getFragment());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("externalizing link for '{}': {} -> {}", new Object[]{domain, path, url});
        }
        return url.toString();
    }

    @Override
    public String publishLink(ResourceResolver resolver, String path) {
        return this.externalLink(resolver, "publish", null, path);
    }

    @Override
    public String publishLink(ResourceResolver resolver, String scheme, String path) {
        return this.externalLink(resolver, "publish", scheme, path);
    }

    @Override
    public String authorLink(ResourceResolver resolver, String path) {
        return this.externalLink(resolver, "author", null, path);
    }

    @Override
    public String authorLink(ResourceResolver resolver, String scheme, String path) {
        return this.externalLink(resolver, "author", scheme, path);
    }
}

