/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Doctype {
    HTML_5("<!DOCTYPE HTML>"),
    HTML_401_STRICT("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">"),
    HTML_401_TRANS("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">"),
    HTML_401_FRAMESET("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">"),
    XHTML_10_STRICT("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"),
    XHTML_10_TRANS("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"),
    XHTML_10_FRAMESET("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">"),
    XHTML_11("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");

    public static final String REQUEST_ATTRIBUTE_NAME;
    private static final Logger log;
    private final String declaration;

    private Doctype(String declaration) {
        this.declaration = declaration;
    }

    public String getDeclaration() {
        return this.declaration;
    }

    public boolean isXHTML() {
        return this.name().startsWith("XHTML_");
    }

    public static boolean isXHTML(ServletRequest req) {
        Doctype d = Doctype.fromRequest(req);
        return d != null && d.isXHTML();
    }

    public static Doctype fromRequest(ServletRequest req) {
        com.day.cq.widget.Doctype newDT = com.day.cq.widget.Doctype.fromRequest((ServletRequest)req);
        if (newDT != null) {
            return Doctype.valueOf(newDT.name());
        }
        Object o = req.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (o == null) {
            return null;
        }
        if (o instanceof Doctype) {
            com.day.cq.widget.Doctype.valueOf((String)((Doctype)((Object)o)).name()).toRequest(req);
            return (Doctype)((Object)o);
        }
        log.error("Object stored in request is not of an instance of Doctype: {}. Returning null.", o);
        return null;
    }

    public void toRequest(ServletRequest req) {
        Doctype prev = Doctype.fromRequest(req);
        if (prev != null && !prev.equals((Object)this)) {
            log.warn("Overwriting existing request doctype ({}) with differnt value {}", (Object)prev, (Object)this);
        }
        req.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)this);
        com.day.cq.widget.Doctype.valueOf((String)this.name()).toRequest(req);
        if (log.isDebugEnabled()) {
            log.debug("Setting request doctype to {}", (Object)this);
        }
    }

    static {
        REQUEST_ATTRIBUTE_NAME = Doctype.class.getName();
        log = LoggerFactory.getLogger(Doctype.class);
    }
}

