/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.xss.ProtectionContext;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.XSSProtectionService;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;

class Item {
    private final String key;
    private final String value;
    private final JSONWriterUtil.WriteMode writeMode;
    private final XSSProtectionService xss;
    private final Logger log;
    private String xssKey;
    private String xssValue;

    Item(String key, String value, JSONWriterUtil.WriteMode writeMode, XSSProtectionService xss, Logger log) throws JSONException {
        this.key = key;
        this.value = value;
        this.writeMode = writeMode;
        this.xss = xss;
        this.log = log;
        this.init();
    }

    private void init() throws JSONException {
        if (this.isAvoidXSS()) {
            if (this.xss != null) {
                this.xssKey = this.key;
                if (this.isPlainText()) {
                    this.xssKey = this.xssKey + "_xss";
                }
                try {
                    this.xssValue = this.xss.protectForContext(ProtectionContext.PLAIN_HTML_CONTENT, this.value);
                }
                catch (XSSProtectionException e) {
                    throw new JSONException("Unable to write XSS protected value for key[" + this.key + "] " + this.value, (Throwable)e);
                }
            } else {
                this.log.warn("XSS protection service was not provided or not available while processing key [{}]", (Object)this.key);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getXssKey() {
        return this.xssKey;
    }

    public String getXssValue() {
        return this.xssValue;
    }

    public boolean isPlainText() {
        return this.writeMode == null || JSONWriterUtil.WriteMode.PLAIN_TEXT.equals((Object)this.writeMode) || JSONWriterUtil.WriteMode.BOTH.equals((Object)this.writeMode);
    }

    public boolean isAvoidXSS() {
        return JSONWriterUtil.WriteMode.AVOID_XSS.equals((Object)this.writeMode) || JSONWriterUtil.WriteMode.BOTH.equals((Object)this.writeMode);
    }
}

