/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.adobe.granite.license.ProductInfo;
import com.adobe.granite.license.ProductInfoProvider;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrPropertyMap;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
public class CQProductInfoProvider
implements ProductInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(CQProductInfoProvider.class);
    private static final String[] PATHS = new String[]{"/apps/", "/libs/"};
    private static final String NN_PRODUCT_INFO = "productinfo";
    private static final String PN_NAME = "name";
    private static final String PN_SHORT_NAME = "shortName";
    private static final String PN_VERSION = "version";
    private static final String PN_SHORT_VERSION = "shortVersion";
    private static final String PN_YEAR = "year";
    private static final String PN_URL = "url";
    private static final String PN_VENDOR = "vendor";
    private static final String PN_VENDOR_URL = "vendorUrl";
    @Reference
    private SlingRepository repository;
    private ProductInfo info;

    public ProductInfo getProductInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    private void activate() {
        if (this.info == null) {
            String name = "cq/core/productinfo";
            Session admin = null;
            try {
                admin = this.repository.loginAdministrative(null);
                Node infoNode = null;
                for (String p : PATHS) {
                    if (!admin.nodeExists(p + name)) continue;
                    infoNode = admin.getNode(p + name);
                    break;
                }
                if (infoNode == null) {
                    log.warn("No product information node found for {}", (Object)name);
                } else {
                    HashMap props = new HashMap(new JcrPropertyMap(infoNode));
                    this.info = new InfoImpl((ValueMap)new ValueMapDecorator(props));
                }
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving product information.", (Throwable)e);
            }
            finally {
                if (admin != null) {
                    admin.logout();
                }
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static class InfoImpl
    implements ProductInfo {
        private final ValueMap props;

        private InfoImpl(ValueMap props) {
            this.props = props;
        }

        public String getName() {
            return (String)this.props.get(CQProductInfoProvider.PN_NAME, (Object)"");
        }

        public String getShortName() {
            return (String)this.props.get(CQProductInfoProvider.PN_SHORT_NAME, (Object)"");
        }

        public Version getVersion() {
            String s = (String)this.props.get(CQProductInfoProvider.PN_VERSION, (Object)"");
            return new Version(s.replace("SNAPSHOT.", "SNAPSHOT-"));
        }

        public String getShortVersion() {
            return (String)this.props.get(CQProductInfoProvider.PN_SHORT_VERSION, (Object)"");
        }

        public String getYear() {
            return (String)this.props.get(CQProductInfoProvider.PN_YEAR, (Object)"");
        }

        public String getVendor() {
            return (String)this.props.get(CQProductInfoProvider.PN_VENDOR, (Object)"");
        }

        public String getVendorUrl() {
            return (String)this.props.get(CQProductInfoProvider.PN_VENDOR_URL, (Object)"");
        }

        public String getUrl() {
            return (String)this.props.get(CQProductInfoProvider.PN_URL, (Object)"");
        }

        public ValueMap getProperties() {
            return this.props;
        }
    }
}

