/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.cq.commons.folderpreview.FolderPreviewResourceManager;
import com.day.cq.commons.folderpreview.FolderPreviewResourceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Adobe CQ Folder Preview Resource Manager", description="Manages registered Folder Preview Resource Providers.")
@Service
public class FolderPreviewResourceManagerImpl
implements FolderPreviewResourceManager {
    private final Logger log = LoggerFactory.getLogger(FolderPreviewResourceManagerImpl.class);
    @Reference(referenceInterface=FolderPreviewResourceProvider.class, bind="bindFolderPreviewResourceProvider", unbind="unbindFolderPreviewResourceProvider", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private List<FolderPreviewResourceProvider> providers = new ArrayList<FolderPreviewResourceProvider>();

    protected void bindFolderPreviewResourceProvider(FolderPreviewResourceProvider ref, Map<?, ?> properties) {
        this.providers.add(ref);
    }

    protected void unbindFolderPreviewResourceProvider(FolderPreviewResourceProvider ref, Map<?, ?> properties) {
        this.providers.remove(ref);
    }

    @Override
    public Resource getPreviewResource(Resource folderChild) {
        for (FolderPreviewResourceProvider candidateProvider : this.providers) {
            Resource candidateResource = candidateProvider.getPreviewResource(folderChild);
            if (candidateResource == null) continue;
            return candidateResource;
        }
        return null;
    }
}

