/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.impl;

import com.day.util.diff.Document;
import com.day.util.diff.ElementsFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordsElementsFactory
implements ElementsFactory {
    private static final int TEXT = 0;
    private static final int ELEMENT = 1;
    private static final int QUOTE1 = 2;
    private static final int QUOTE2 = 3;
    private final Document.Element[] elements;

    public WordsElementsFactory(Document.Element[] elements) {
        this.elements = elements;
    }

    public Document.Element[] getElements() {
        return this.elements;
    }

    public static ElementsFactory create(String text) {
        return new WordsElementsFactory(WordsElementsFactory.filterHtmlTagsAndSplitWords(text));
    }

    public static ElementsFactory create(String text, String[] includedHtmlTags) {
        return new WordsElementsFactory(WordsElementsFactory.filterHtmlTagsAndSplitWords(text, includedHtmlTags));
    }

    private static WordElement[] filterHtmlTagsAndSplitWords(String text) {
        return WordsElementsFactory.filterHtmlTagsAndSplitWords(text, null);
    }

    private static WordElement[] filterHtmlTagsAndSplitWords(String text, String[] includedHtmlTags) {
        ArrayList<WordElement> words = new ArrayList<WordElement>();
        int start = 0;
        int mode = 0;
        block6: for (int pos = 0; pos < text.length(); ++pos) {
            char c = text.charAt(pos);
            switch (mode) {
                case 0: {
                    if (c != '<') continue block6;
                    if (pos > start) {
                        WordsElementsFactory.scanForWords(words, text, start, pos);
                        start = pos;
                    }
                    mode = 1;
                    continue block6;
                }
                case 1: {
                    if (c == '>') {
                        if (WordsElementsFactory.startsWithIncludedHtmlTag(text.substring(start + 1), includedHtmlTags)) {
                            String element = text.substring(start, pos + 1);
                            words.add(new WordElement(element, start));
                        }
                        start = pos + 1;
                        mode = 0;
                        continue block6;
                    }
                    if (c == '\'') {
                        mode = 2;
                        continue block6;
                    }
                    if (c != '\"') continue block6;
                    mode = 3;
                    continue block6;
                }
                case 2: {
                    if (c != '\'') continue block6;
                    mode = 1;
                    continue block6;
                }
                case 3: {
                    if (c != '\"') continue block6;
                    mode = 1;
                }
            }
        }
        if (start < text.length()) {
            WordsElementsFactory.scanForWords(words, text, start, text.length());
        }
        return words.toArray(new WordElement[words.size()]);
    }

    private static boolean startsWithIncludedHtmlTag(String text, String[] includedHtmlTags) {
        for (String includedHtmlTag : includedHtmlTags) {
            if (!text.startsWith(includedHtmlTag)) continue;
            return true;
        }
        return false;
    }

    private static void scanForWords(List<WordElement> words, String text, int textStart, int textEnd) {
        int start = textStart;
        for (int pos = textStart; pos < textEnd; ++pos) {
            char c = text.charAt(pos);
            if (Character.isWhitespace(c)) {
                if (pos > start) {
                    words.add(new WordElement(text.substring(start, pos), start));
                }
                start = pos + 1;
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                if (pos <= start || text.charAt(pos - 1) == c) continue;
                words.add(new WordElement(text.substring(start, pos), start));
                start = pos;
                continue;
            }
            if (pos <= start || Character.isLetterOrDigit(text.charAt(pos - 1))) continue;
            words.add(new WordElement(text.substring(start, pos), start));
            start = pos;
        }
        if (start < textEnd) {
            words.add(new WordElement(text.substring(start, textEnd), start));
        }
    }

    public static class WordElement
    implements Document.Element {
        private final String word;
        private int index;

        public WordElement(String word, int index) {
            this.word = word;
            this.index = index;
        }

        public String getString() {
            return this.word;
        }

        public int getIndex() {
            return this.index;
        }

        public void incrementIndex(int value) {
            this.index += value;
        }

        public String toString() {
            return this.getString() + "<" + this.index + ">";
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WordElement) {
                return ((WordElement)obj).word.equals(this.word);
            }
            return false;
        }
    }
}

