/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.compat.commonsauth.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
Runnable {
    private static final String COMMONS_AUTH_NAME = "org.apache.sling.commons.auth";
    private static final String FILE_BUNDLE_CHECKED = "commons.auth.checked";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private Bundle[] bundlesToRemove;

    public void start(BundleContext context) {
        if (!this.isCommonsAuthChecked(context)) {
            Bundle[] bundles = context.getBundles();
            ArrayList<Bundle> touninstall = new ArrayList<Bundle>();
            for (Bundle bundle : bundles) {
                if (!COMMONS_AUTH_NAME.equals(bundle.getSymbolicName())) continue;
                touninstall.add(bundle);
            }
            if (!touninstall.isEmpty()) {
                this.log.info("Compat-Commons-Auth: Preparing to remove {} bundles", (Object)touninstall.size());
                this.bundlesToRemove = touninstall.toArray(new Bundle[touninstall.size()]);
                this.bundleContext = context;
                this.startThread();
            } else {
                this.setCommonsAuthChecked(context);
            }
        }
    }

    public void stop(BundleContext context) {
    }

    private boolean isCommonsAuthChecked(BundleContext context) {
        File ckFile = context.getDataFile(FILE_BUNDLE_CHECKED);
        return ckFile != null && ckFile.exists();
    }

    private void setCommonsAuthChecked(BundleContext context) {
        File ckFile = context.getDataFile(FILE_BUNDLE_CHECKED);
        if (ckFile != null) {
            try {
                ckFile.createNewFile();
            }
            catch (IOException ioe) {
                this.log.warn("Compat-Commons-Auth: Failed to create check file " + ckFile.getAbsolutePath(), (Throwable)ioe);
            }
        }
    }

    private void startThread() {
        this.log.info("Compat-Commons-Auth: Starting thread to uninstall bundle(s)");
        Thread worker = new Thread((Runnable)this, "Commons Auth Uninstaller");
        worker.setDaemon(true);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Bundle[] touninstall = this.bundlesToRemove;
        this.bundlesToRemove = null;
        for (Bundle bundle : touninstall) {
            try {
                this.log.info("Compat-Commons-Auth: Uninstalling bundle {}", (Object)bundle);
                bundle.uninstall();
            }
            catch (BundleException be) {
                // empty catch block
            }
        }
        ServiceReference sr = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        if (sr != null) {
            PackageAdmin pa = (PackageAdmin)this.bundleContext.getService(sr);
            try {
                this.log.info("Compat-Commons-Auth: Refreshing packages for {} bundles", (Object)touninstall.length);
                pa.refreshPackages(touninstall);
            }
            finally {
                this.bundleContext.ungetService(sr);
            }
        }
        this.setCommonsAuthChecked(this.bundleContext);
        this.log.info("Compat-Commons-Auth: Done uninstalling bundles");
    }
}

