/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.compat.commonsauth.impl;

import com.day.cq.compat.commonsauth.impl.AuthenticationHandlerBridge;
import com.day.cq.compat.commonsauth.impl.AuthenticationInfoPostProcessorBridge;
import com.day.cq.compat.commonsauth.impl.Bridge;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.commons.auth.spi.AuthenticationHandler;
import org.apache.sling.commons.auth.spi.AuthenticationInfoPostProcessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerBridgeManager {
    private final HashMap<Bridge, Object> bridgeServices = new HashMap();
    private BundleContext bundleContext;

    private synchronized void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        for (Map.Entry<Bridge, Object> entry : this.bridgeServices.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            entry.setValue(this.registerService(entry.getKey(), (Map)entry.getValue()));
        }
    }

    private synchronized void deactivate() {
        this.bundleContext = null;
    }

    private synchronized void bindAuthenticationHandler(AuthenticationHandler handler, Map<String, Object> properties) {
        AuthenticationHandlerBridge bridge = new AuthenticationHandlerBridge(handler);
        this.serviceAdded(bridge, properties);
    }

    private synchronized void unbindAuthenticationHandler(AuthenticationHandler handler) {
        AuthenticationHandlerBridge bridge = new AuthenticationHandlerBridge(handler);
        this.serviceRemoved(bridge);
    }

    private synchronized void bindAuthenticationInfoPostProcessor(AuthenticationInfoPostProcessor processor, Map<String, Object> properties) {
        AuthenticationInfoPostProcessorBridge bridge = new AuthenticationInfoPostProcessorBridge(processor);
        this.serviceAdded(bridge, properties);
    }

    private synchronized void unbindAuthenticationInfoPostProcessor(AuthenticationInfoPostProcessor processor) {
        AuthenticationInfoPostProcessorBridge bridge = new AuthenticationInfoPostProcessorBridge(processor);
        this.serviceRemoved(bridge);
    }

    private void serviceAdded(Bridge service, Map<String, Object> properties) {
        if (this.bundleContext != null) {
            this.bridgeServices.put(service, this.registerService(service, properties));
        } else {
            this.bridgeServices.put(service, properties);
        }
    }

    private void serviceRemoved(Object service) {
        Object registered = this.bridgeServices.remove(service);
        if (registered instanceof ServiceRegistration) {
            try {
                ((ServiceRegistration)registered).unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private ServiceRegistration registerService(Bridge service, Map<String, Object> properties) {
        Hashtable<String, Object> props = new Hashtable<String, Object>(properties);
        props.remove("service.id");
        props.remove("service.pid");
        props.remove("objectClass");
        props.remove("component.name");
        props.remove("component.id");
        props.put("service.description", service.toString());
        return this.bundleContext.registerService(service.getServiceName(), (Object)service, props);
    }
}

