/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.compat.cqupgrade.impl;

import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqUpgradeBundlesStarter {
    private static long activationCounter = System.currentTimeMillis();
    public static final String UPGRADE_PROPERTY = "crx.quickstart.upgrading.to";
    public static final String JCRINSTALL_SYMBOLIC_NAME = "org.apache.sling.installer.provider.jcr";
    public static final long WAIT_BETWEEN_TRIES_MSEC = 2500L;
    public static final int MAX_MINUTES_TO_TRY = 5;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected void activate(ComponentContext ctx) {
        ++activationCounter;
        if (System.getProperty(UPGRADE_PROPERTY) == null) {
            this.log.info("{} property not set - not an upgrade, will do nothing", (Object)UPGRADE_PROPERTY);
            return;
        }
        this.log.info("{} property indicates an upgrade, will try to start all bundles", (Object)UPGRADE_PROPERTY);
        StarterTask r = new StarterTask(ctx.getBundleContext(), activationCounter);
        Thread t = new Thread((Runnable)r, this.getClass().getSimpleName() + "#" + activationCounter);
        t.setDaemon(true);
        t.start();
    }

    protected void deactivate(ComponentContext ctx) throws InterruptedException {
        ++activationCounter;
    }

    class StarterTask
    implements Runnable {
        private final long myCount;
        private final BundleContext bundleContext;

        StarterTask(BundleContext bundleContext, long counter) {
            this.bundleContext = bundleContext;
            this.myCount = counter;
        }

        void checkActive() throws StarterTaskException {
            if (this.myCount != activationCounter) {
                throw new StarterTaskException();
            }
        }

        public void run() {
            boolean jcrinstallActive = false;
            CqUpgradeBundlesStarter.this.log.debug("{} thread starts", (Object)Thread.currentThread().getName());
            long giveUpTime = System.currentTimeMillis() + 300000L;
            try {
                while (true) {
                    Bundle[] all;
                    this.checkActive();
                    if (System.currentTimeMillis() > giveUpTime) {
                        CqUpgradeBundlesStarter.this.log.warn("Giving up after {} minutes, unable to start all bundles", (Object)5);
                        break;
                    }
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    this.checkActive();
                    if (!jcrinstallActive) {
                        Bundle b = this.findBundle(CqUpgradeBundlesStarter.JCRINSTALL_SYMBOLIC_NAME);
                        if (b.getState() != 32) continue;
                        CqUpgradeBundlesStarter.this.log.info("{} bundle is active, ready to try starting all bundles", (Object)CqUpgradeBundlesStarter.JCRINSTALL_SYMBOLIC_NAME);
                        jcrinstallActive = true;
                        continue;
                    }
                    int notStarted = 0;
                    for (Bundle b : all = this.bundleContext.getBundles()) {
                        this.checkActive();
                        int state = b.getState();
                        if (this.isStarted(state) || this.isFragment(b)) continue;
                        CqUpgradeBundlesStarter.this.log.debug("Bundle {} is in state {}, trying to start", (Object)b.getSymbolicName(), (Object)state);
                        try {
                            b.start();
                        }
                        catch (IllegalStateException iex) {
                            CqUpgradeBundlesStarter.this.log.info("IllegalStateException starting bundle " + b.getSymbolicName(), (Throwable)iex);
                            continue;
                        }
                        catch (BundleException be) {
                            CqUpgradeBundlesStarter.this.log.info("BundleException starting bundle " + b.getSymbolicName(), (Throwable)be);
                            continue;
                        }
                        if (this.isStarted(b.getState())) {
                            CqUpgradeBundlesStarter.this.log.info("Bundle {} started (or starting)", (Object)b.getSymbolicName());
                            continue;
                        }
                        ++notStarted;
                    }
                    if (notStarted == 0) {
                        CqUpgradeBundlesStarter.this.log.info("All {} bundles started, exiting", (Object)all.length);
                        break;
                    }
                    CqUpgradeBundlesStarter.this.log.info("{} bundles left to start", (Object)notStarted);
                }
                CqUpgradeBundlesStarter.this.log.info("StarterTask: normal exit ({})", (Object)Thread.currentThread().getName());
            }
            catch (StarterTaskException ste) {
                CqUpgradeBundlesStarter.this.log.info("StarterTask stopped due to changed activation count ({})", (Object)Thread.currentThread().getName());
            }
        }

        private boolean isStarted(int state) {
            return state == 32 || state == 8;
        }

        private Bundle findBundle(String symbolicName) {
            Bundle[] all;
            for (Bundle b : all = this.bundleContext.getBundles()) {
                if (!b.getSymbolicName().equals(symbolicName)) continue;
                return b;
            }
            return null;
        }

        private boolean isFragment(Bundle bundle) {
            Dictionary headerMap = bundle.getHeaders();
            return headerMap.get("Fragment-Host") != null;
        }
    }

    static class StarterTaskException
    extends Exception {
        StarterTaskException() {
        }
    }
}

